/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestCustomWorkflowScreenLocalization
extends FuncTestCase {
    public static final String WORKFLOW_NAME = "Workflow2";

    @Override
    public void setUpTest() {
        this.administration.restoreData("TestCustomWorkflowScreenLocalization.xml");
    }

    public void testSubmitButtonLabelIsTransitionName() {
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve");
    }

    public void testSubmitButtonLabelIsLocalized() {
        this.administration.workflows().goTo().createDraft(WORKFLOW_NAME);
        this.backdoor.workflow().setTransitionProperty(WORKFLOW_NAME, true, 11L, "jira.i18n.submit", "resolveissue.title");
        this.administration.workflows().goTo().publishDraft(WORKFLOW_NAME).publish();
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve Issue");
    }

    public void testFallBackToTransitionName() {
        this.administration.workflows().goTo().createDraft(WORKFLOW_NAME);
        this.administration.workflows().goTo().edit(WORKFLOW_NAME).textView().goTo();
        this.backdoor.workflow().setTransitionProperty(WORKFLOW_NAME, true, 11L, "jira.i18n.submit", "blah.doesnt.exist");
        this.administration.workflows().goTo().publishDraft(WORKFLOW_NAME).publish();
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve");
    }

    public void testTransitionNameTitle() {
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve");
        this.tester.assertTitleEquals("Resolve [HMS-1] - Your Company JIRA");
    }

    public void testLocalizedTitle() {
        this.administration.workflows().goTo().createDraft(WORKFLOW_NAME);
        this.administration.workflows().goTo().edit(WORKFLOW_NAME).textView().goTo();
        this.backdoor.workflow().setTransitionProperty(WORKFLOW_NAME, true, 11L, "jira.i18n.title", "resolveissue.title");
        this.administration.workflows().goTo().publishDraft(WORKFLOW_NAME).publish();
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve");
        this.tester.assertTitleEquals("Resolve Issue [HMS-1] - Your Company JIRA");
    }

    public void testFixedDescription() {
        this.administration.workflows().goTo().createDraft(WORKFLOW_NAME);
        this.administration.workflows().goTo().edit(WORKFLOW_NAME).textView().goTo();
        this.backdoor.workflow().setTransitionProperty(WORKFLOW_NAME, true, 11L, "description", "My Special description");
        this.administration.workflows().goTo().publishDraft(WORKFLOW_NAME).publish();
        this.navigation.issue().viewIssue("HMS-1");
        this.tester.clickLink("action_id_11");
        this.tester.setWorkingForm("issue-workflow-transition");
        this.assertions.assertSubmitButtonPresentWithText("issue-workflow-transition-submit", "Resolve");
        this.tester.assertTextPresent("My Special description");
    }
}

