/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.functest.framework.admin.ViewWorkflows;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.google.common.collect.Iterables;
import java.text.SimpleDateFormat;
import java.util.Date;

@WebTest(value={Category.FUNC_TEST, Category.WORKFLOW})
public class TestCustomWorkflow
extends JIRAWebTest {
    public TestCustomWorkflow(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConditionsUseUnmodifiedIssue() {
        this.administration.restoreData("TestCustomWorkflow.xml");
        this.administration.workflows().goTo().copyWorkflow("jira_old", "Copied Workflow", "Workflow copied from JIRA default");
        TestCustomWorkflow.assertTrue((boolean)this.administration.workflows().goTo().inactive().contains("Copied Workflow"));
        ViewWorkflows.WorkflowItem copiedWorkflowItem = (ViewWorkflows.WorkflowItem)this.administration.workflows().goTo().inactive().get(0);
        TestCustomWorkflow.assertTrue((boolean)copiedWorkflowItem.lastModified().contains(new SimpleDateFormat("dd/MMM/yy").format(new Date())));
        TestCustomWorkflow.assertTrue((boolean)copiedWorkflowItem.lastModified().contains("Administrator"));
        this.editTransitionScreen("Copied Workflow", "Start Progress", "Workflow Screen");
        this.addWorkflowPostfunction("Copied Workflow", "In Progress", "Stop Progress", "com.atlassian.jira.plugin.system.workflow:assigntolead-function");
        this.enableWorkflow();
        String key = this.navigation.issue().createIssue("homosapien", "Bug", "Test Issue");
        try {
            this.getBackdoor().darkFeatures().enableForSite("no.frother.assignee.field");
            this.getNavigation().issue().viewIssue(key);
            this.clickLinkWithText("Start Progress");
            this.selectOption("assignee", "Bob The Builder");
        }
        finally {
            this.getBackdoor().darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.tester.submit();
        TestCustomWorkflow.assertNotNull((Object)this.tester.getDialog().getResponse().getURL());
        TestCustomWorkflow.assertTrue((boolean)this.tester.getDialog().getResponse().getURL().getPath().endsWith("browse/" + key));
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "In Progress");
        this.text.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "Bob The Builder");
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        this.navigation.issue().gotoIssue(key);
        this.tester.clickLinkWithText("Stop Progress");
        this.text.assertTextPresent(new IdLocator(this.tester, "status-val"), "Open");
        this.text.assertTextPresent(new IdLocator(this.tester, "assignee-val"), "Administrator");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
    }

    public void testLastModifiedWithFunnyCharacters() {
        this.administration.restoreData("blankWithOldDefault.xml");
        this.addUser("\"meta\"user", "meta", "\"meta\" user lastname", "meta@example.com");
        this.getAdministration().usersAndGroups().addUserToGroup("\"meta\"user", "jira-administrators");
        this.navigation.logout();
        this.navigation.login("\"meta\"user", "meta");
        this.administration.workflows().goTo().copyWorkflow("jira", "Copied Workflow", "Workflow copied from JIRA default");
        TestCustomWorkflow.assertTrue((boolean)this.administration.workflows().goTo().inactive().contains("Copied Workflow"));
        ViewWorkflows.WorkflowItem copiedWorkflowItem = (ViewWorkflows.WorkflowItem)Iterables.getOnlyElement((Iterable)((Object)this.administration.workflows().goTo().inactive()));
        TestCustomWorkflow.assertTrue((boolean)copiedWorkflowItem.lastModified().contains(new SimpleDateFormat("dd/MMM/yy").format(new Date())));
        TestCustomWorkflow.assertTrue((boolean)copiedWorkflowItem.lastModified().contains("\"meta\" user lastname"));
    }

    private void enableWorkflow() {
        this.addWorkFlowScheme("New Workflow Scheme", "Test workflow scheme.");
        this.assignWorkflowScheme(10000L, "Bug", "Copied Workflow");
        this.administration.project().associateWorkflowScheme("homosapien", "New Workflow Scheme", null, true);
        this.waitForSuccessfulWorkflowSchemeMigration("homosapien", "New Workflow Scheme");
    }
}

