/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.workflow;

import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.webtests.ztests.workflow.AbstractTestWorkflowSchemeMigration;
import java.util.Map;

public abstract class AbstractTestDraftWorkflowSchemeMigration
extends AbstractTestWorkflowSchemeMigration {
    protected static final String TEST_PROJECT_NAME_II = "Test Project II";
    protected static final String TEST_PROJECT_KEY_II = "TSTII";
    protected static final long TEST_PROJECT_ID = 10000L;
    protected static final long TEST_PROJECT_ID_II = 10010L;
    protected static final String COPY_OF_SOURCE_WORKFLOW_SCHEME = "Copy of Source Workflow Scheme";
    protected static final String COPY_2_OF_SOURCE_WORKFLOW_SCHEME = "Copy 2 of Source Workflow Scheme";
    protected static final String SOURCE_SCHEME_DESCRIPTION = "The workflow scheme the project started on";
    protected static final String COPY_OF_SOURCE_WORKFLOW_SCHEME_DESCRIPTION = "The workflow scheme the project started on (This copy was automatically generated from a draft, as an intermediate scheme for migration)";
    protected static final long SOURCE_SCHEME_ID = 10000L;
    protected static final Map<String, String> DRAFT_WORKFLOW_MAPPING = MapBuilder.newBuilder().add("Task", "jira").toMap();
    protected static final Map<String, String> SOURCE_SCHEME_WORKFLOW_MAPPING = MapBuilder.newBuilder().add("Bug", "Source Workflow 2").toMap();

    public AbstractTestDraftWorkflowSchemeMigration(String name) {
        super(name);
    }

    protected void publishDraft() {
        Map<String, String> statusMapping = this.createTestWorkflowMigrationMapping();
        Long schemeId = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectKey("TST").getId();
        this.administration.project().publishWorkflowSchemeDraft("Test Project", schemeId, statusMapping, true);
    }

    protected void assertSchemeAndNoDraft(String projectName) {
        this.assertScheme(projectName);
        this.assertNoDraft(projectName);
    }

    protected void assertNoDraft(String projectName) {
        AbstractTestDraftWorkflowSchemeMigration.assertNull((Object)this.getBackdoor().workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound(projectName));
    }

    protected void assertDraft(String projectName) {
        WorkflowSchemeData draft = this.getBackdoor().workflowSchemes().getWorkflowSchemeDraftByProjectNameNullIfNotFound(projectName);
        AbstractTestDraftWorkflowSchemeMigration.assertNotNull((Object)draft);
        AbstractTestDraftWorkflowSchemeMigration.assertEquals((String)"Source Workflow Scheme", (String)draft.getName());
        AbstractTestDraftWorkflowSchemeMigration.assertEquals(DRAFT_WORKFLOW_MAPPING, (Object)draft.getMappings());
    }

    protected void assertScheme(String projectName) {
        this.assertScheme(projectName, "Source Workflow Scheme", SOURCE_SCHEME_DESCRIPTION, DRAFT_WORKFLOW_MAPPING, "Destinatiom Workflow");
    }

    protected void assertScheme(String projectName, String schemeName, String schemeDescription, Map<String, String> workflowMapping, String defaultWorkflow) {
        WorkflowSchemeData schemeData = this.getBackdoor().workflowSchemes().getWorkflowSchemeByProjectName(projectName);
        AbstractTestDraftWorkflowSchemeMigration.assertEquals((String)schemeName, (String)schemeData.getName());
        AbstractTestDraftWorkflowSchemeMigration.assertEquals((String)schemeDescription, (String)schemeData.getDescription());
        AbstractTestDraftWorkflowSchemeMigration.assertEquals(workflowMapping, (Object)schemeData.getMappings());
        AbstractTestDraftWorkflowSchemeMigration.assertEquals((String)defaultWorkflow, (String)schemeData.getDefaultWorkflow());
    }

    protected void assertSchemeIdChanged(String schemeName, long id) {
        WorkflowSchemeData schemeData = this.getBackdoor().workflowSchemes().getWorkflowSchemeByName(schemeName);
        AbstractTestDraftWorkflowSchemeMigration.assertFalse((boolean)schemeData.getId().equals(id));
    }

    protected void assertSchemeId(String schemeName, long id) {
        WorkflowSchemeData schemeData = this.getBackdoor().workflowSchemes().getWorkflowSchemeByName(schemeName);
        AbstractTestDraftWorkflowSchemeMigration.assertEquals((long)schemeData.getId(), (long)id);
    }

    protected void assertInactiveSchemeExists(String schemeName, String schemeDescription) {
        WorkflowSchemeData schemeData = this.getBackdoor().workflowSchemes().getWorkflowSchemeByNameNullIfNotFound(schemeName);
        AbstractTestDraftWorkflowSchemeMigration.assertNotNull((Object)schemeData);
        AbstractTestDraftWorkflowSchemeMigration.assertEquals((String)schemeDescription, (String)schemeData.getDescription());
        AbstractTestDraftWorkflowSchemeMigration.assertFalse((boolean)schemeData.isActive());
    }

    protected void assertNoScheme(String schemeName) {
        AbstractTestDraftWorkflowSchemeMigration.assertNull((Object)this.getBackdoor().workflowSchemes().getWorkflowSchemeByNameNullIfNotFound(schemeName));
    }

    protected void assertMultiAdminTaskProgressFlow(long projectId) {
        long taskId = this.getSubmittedTaskId();
        this.waitForTaskAcknowledgement(taskId);
        this.assertTextPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.assertTextNotPresent("input type=\"submit\" name=\"Done\"");
        this.validateProgressBarUI("Acknowledge");
        this.navigation.logout();
        this.navigation.login("admin2", "admin2");
        this.navigation.gotoAdmin();
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=" + projectId + "&taskId=" + taskId + "&draftMigration=true");
        this.validateProgressBarUI("Done");
        this.assertTextNotPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.assertTextPresent("input type=\"submit\" name=\"Done\"");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdmin();
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=" + projectId + "&taskId=" + taskId + "&draftMigration=true");
        this.assertTextPresent("input type=\"submit\" name=\"Acknowledge\"");
        this.assertTextNotPresent("input type=\"submit\" name=\"Done\"");
        this.validateProgressBarUI("Acknowledge");
        this.submit("Acknowledge");
        this.gotoPage("/secure/project/SelectProjectWorkflowSchemeStep3.jspa?projectId=" + projectId + "&taskId=" + taskId + "&draftMigration=true");
        this.assertTextPresent("The task could not be found. Perhaps it has finished and has been acknowledged?");
        this.assertTextPresent("input type=\"submit\" name=\"Done\"");
    }
}

