/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.util.HashMap;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.ISSUES, Category.ISSUE_NAVIGATOR})
public class TestUserRenameOnWorkflow
extends FuncTestCase {
    public static final String DAIRY_COMPONENT_ID = "10000";
    public static final String BEEF_COMPONENT_ID = "10001";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("user_rename_post_functions.xml");
    }

    public void testPostFunctionAssignsToRenamedUser() {
        HashMap<String, String[]> withDairyComponent = new HashMap<String, String[]>();
        HashMap<String, String[]> withBeefComponent = new HashMap<String, String[]>();
        withDairyComponent.put("components", new String[]{DAIRY_COMPONENT_ID});
        withBeefComponent.put("components", new String[]{BEEF_COMPONENT_ID});
        this.renameUser("bb", "robert");
        this.renameUser("betty", "bboop");
        this.navigation.login("robert", "bb");
        String dairyIssueKey = this.navigation.issue().createIssue("Bovine", "Task", "Milk Old Bessie", withDairyComponent);
        this.navigation.issue().gotoIssue(dairyIssueKey);
        this.navigation.clickLinkWithExactText("Assign To Me");
        this.navigation.clickLinkWithExactText("Start Progress");
        TestUserRenameOnWorkflow.assertEquals((String)"bboop", (String)this.assigneeOf(dairyIssueKey));
        this.navigation.issue().resolveIssue(dairyIssueKey, "Fixed", "Old Bessie was not cooperative, but the deed is done.");
        TestUserRenameOnWorkflow.assertEquals((String)"robert", (String)this.assigneeOf(dairyIssueKey));
        this.navigation.issue().reopenIssue(dairyIssueKey);
        TestUserRenameOnWorkflow.assertEquals((String)"bboop", (String)this.assigneeOf(dairyIssueKey));
        this.navigation.login("bboop", "betty");
        this.navigation.issue().gotoIssue(dairyIssueKey);
        this.navigation.clickLinkWithExactText("Start Progress");
        TestUserRenameOnWorkflow.assertEquals((String)"bboop", (String)this.assigneeOf(dairyIssueKey));
        this.navigation.login("robert", "bb");
        this.navigation.issue().gotoIssue(dairyIssueKey);
        this.navigation.clickLinkWithExactText("Stop Progress");
        TestUserRenameOnWorkflow.assertEquals((String)"robert", (String)this.assigneeOf(dairyIssueKey));
        String beefIssueKey = this.navigation.issue().createIssue("Bovine", "Task", "Slaughter the young heifer.", withBeefComponent);
        this.navigation.issue().resolveIssue(beefIssueKey, "Won't Fix", "I couldn't bring myself to do it!");
        this.navigation.issue().reopenIssue(beefIssueKey);
        TestUserRenameOnWorkflow.assertEquals((String)"robert", (String)this.assigneeOf(beefIssueKey));
        String calvingIssueKey = this.navigation.issue().createIssue("Bovine", "Task", "Breed Bessie and Buster");
        this.navigation.issue().resolveIssue(calvingIssueKey, "Cannot Reproduce", "They cannot reproduce");
        this.navigation.issue().reopenIssue(calvingIssueKey);
        TestUserRenameOnWorkflow.assertEquals((String)"robert", (String)this.assigneeOf(calvingIssueKey));
    }

    private String assigneeOf(String key) {
        return this.backdoor.issues().getIssue((String)key).fields.assignee.name;
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }
}

