/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.JQL, Category.CHANGE_HISTORY})
public class TestUserRenameOnSearch
extends AbstractJqlFuncTest {
    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("user_rename_search.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "betty");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "cc");
        this.assertSearchWithResultsForUser("admin", "", "COW-4", "COW-3", "COW-2", "COW-1");
    }

    public void testCurrentAssigneeAndReporter() {
        this.assertSearchWithResults("assignee = currentUser()", "COW-4");
        this.assertSearchWithResults("assignee = admin", "COW-4");
        this.assertSearchWithResults("assignee = bb", "COW-3");
        this.assertSearchWithResults("assignee = betty", "COW-1");
        this.assertBadValueWarning("assignee = candy", "assignee", "candy");
        this.assertSearchWithResults("assignee = cat", "COW-2");
        this.assertSearchWithResults("assignee = cc", new String[0]);
        this.assertSearchWithResults("assignee in (betty,bb)", "COW-3", "COW-1");
        this.assertSearchWithResults("assignee in (admin,bb)", "COW-4", "COW-3");
        this.assertSearchWithResults("assignee in (currentUser(),bb)", "COW-4", "COW-3");
        this.assertSearchWithResults("reporter = currentUser()", "COW-4");
        this.assertSearchWithResults("reporter = admin", "COW-4");
        this.assertSearchWithResults("reporter = bb", new String[0]);
        this.assertSearchWithResults("reporter = betty", new String[0]);
        this.assertBadValueWarning("reporter = candy", "reporter", "candy");
        this.assertSearchWithResults("reporter = cat", "COW-2", "COW-1");
        this.assertSearchWithResults("reporter = cc", "COW-3");
        this.assertSearchWithResults("reporter in (cc,cat)", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("reporter in (admin,cat)", "COW-4", "COW-2", "COW-1");
        this.assertSearchWithResults("reporter in (currentUser(),cat)", "COW-4", "COW-2", "COW-1");
    }

    public void testCurrentCustomFieldValue() {
        this.assertSearchWithResults("tester = currentUser()", new String[0]);
        this.assertSearchWithResults("tester = admin", new String[0]);
        this.assertSearchWithResults("tester = bb", new String[0]);
        this.assertSearchWithResults("tester = betty", new String[0]);
        this.assertBadValueWarning("tester = candy", "tester", "candy");
        this.assertSearchWithResults("tester = cat", "COW-3", "COW-2");
        this.assertSearchWithResults("tester = cc", "COW-1");
        this.assertSearchWithResults("tester in (cc,cat)", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("tester in (admin,cat)", "COW-3", "COW-2");
        this.assertSearchWithResults("tester in (currentUser(),cat)", "COW-3", "COW-2");
        this.assertSearchWithResults("cc = currentUser()", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("cc = admin", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("cc = bb", "COW-2", "COW-1");
        this.assertSearchWithResults("cc = betty", "COW-3");
        this.assertBadValueWarning("cc = candy", "cc", "candy");
        this.assertSearchWithResults("cc = cat", new String[0]);
        this.assertSearchWithResults("cc = cc", new String[0]);
        this.assertSearchWithResults("cc in (cc,cat)", new String[0]);
        this.assertSearchWithResults("cc in (admin,cat)", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("cc in (currentUser(),cat)", "COW-3", "COW-2", "COW-1");
    }

    public void testVotersAndWatchers() {
        this.initVotersAndWatchers("betty", "bb");
        this.assertSearchWithResults("voter = currentUser()", new String[0]);
        this.assertSearchWithResults("voter = admin", new String[0]);
        this.assertSearchWithResults("voter = bb", "COW-3");
        this.assertSearchWithResults("voter = betty", "COW-1");
        this.assertBadValueWarning("voter = candy", "voter", "candy");
        this.assertSearchWithResults("voter = cat", new String[0]);
        this.assertSearchWithResults("voter = cc", new String[0]);
        this.assertSearchWithResults("voter in (bb,betty)", "COW-3", "COW-1");
        this.assertSearchWithResults("voter in (admin,bb)", "COW-3");
        this.assertSearchWithResults("voter in (currentUser(),bb)", "COW-3");
        this.assertSearchWithResults("watcher = currentUser()", "COW-4", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("watcher = admin", "COW-4", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("watcher = bb", "COW-4");
        this.assertSearchWithResults("watcher = betty", "COW-2");
        this.assertBadValueWarning("watcher = candy", "watcher", "candy");
        this.assertSearchWithResults("watcher = cat", new String[0]);
        this.assertSearchWithResults("watcher = cc", new String[0]);
        this.assertSearchWithResults("watcher in (bb,betty)", "COW-4", "COW-2");
        this.assertSearchWithResults("watcher in (admin,bb)", "COW-4", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("watcher in (currentUser(),bb)", "COW-4", "COW-3", "COW-2", "COW-1");
    }

    public void testChangedBy() {
        this.assertSearchWithResults("reporter changed by admin", "COW-3", "COW-1");
        this.assertSearchWithResults("reporter changed by bb", "COW-3", "COW-2");
        this.assertSearchWithResults("reporter changed by cat", "COW-3");
        this.assertSearchWithResults("reporter changed by cc", new String[0]);
        this.assertSearchWithResults("assignee changed by admin", "COW-3", "COW-1");
        this.assertSearchWithResults("assignee changed by bb", "COW-2");
        this.assertSearchWithResults("assignee changed by cat", new String[0]);
        this.assertSearchWithResults("assignee changed by cc", new String[0]);
        this.assertByClauseError("reporter changed by asdfasdf", "asdfasdf");
        this.assertByClauseError("assignee changed by candy", "candy");
    }

    public void testWasClauseForAssigneeAndReporter() {
        this.assertSearchWithResults("assignee was currentUser()", "COW-4", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("assignee was admin", "COW-4", "COW-3", "COW-2", "COW-1");
        this.assertBadValueError("assignee was asdfasdf", "assignee", "asdfasdf");
        this.assertSearchWithResults("assignee was bb", "COW-3");
        this.assertBadValueError("assignee was candy", "assignee", "candy");
        this.assertSearchWithResults("assignee was cat", "COW-2");
        this.assertBadValueError("assignee was in (candy, cat)", "assignee", "candy");
        this.assertSearchWithResults("assignee was cc", new String[0]);
        this.assertSearchWithResults("reporter was currentUser()", "COW-4", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("reporter was admin", "COW-4", "COW-3", "COW-2", "COW-1");
        this.assertBadValueError("reporter was asdfasdf", "reporter", "asdfasdf");
        this.assertSearchWithResults("reporter was bb", "COW-3");
        this.assertBadValueError("reporter was candy", "reporter", "candy");
        this.assertSearchWithResults("reporter was cat", "COW-2", "COW-1");
        this.assertBadValueError("reporter was in (candy, cat)", "reporter", "candy");
        this.assertSearchWithResults("reporter was cc", "COW-3");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkBettyAndCandy(String goodBetty, String badBetty, String goodCandy, String badCandy) {
        this.assertSearchWithResults("assignee = " + goodCandy, new String[0]);
        this.assertSearchWithResults("assignee changed by " + goodBetty + "", "COW-1");
        this.assertSearchWithResults("assignee was " + goodBetty + "", "COW-1");
        this.assertSearchWithResults("assignee was in (" + goodBetty + ", cat)", "COW-2", "COW-1");
        this.assertSearchWithResults("assignee was in (" + goodCandy + ", " + goodBetty + ")", "COW-1");
        this.assertSearchWithResults("assignee changed from " + goodBetty + "", new String[0]);
        this.assertSearchWithResults("assignee changed to " + goodBetty + "", "COW-1");
        this.assertSearchWithResults("reporter = " + goodCandy, "COW-3");
        this.assertSearchWithResults("reporter in (" + goodCandy + ", cat)", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("reporter was " + goodBetty + "", "COW-3", "COW-1");
        this.assertSearchWithResults("reporter was in (" + goodBetty + ", cat)", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("reporter was in (" + goodCandy + ", " + goodBetty + ")", "COW-3", "COW-1");
        this.assertSearchWithResults("reporter changed by " + goodBetty + "", "COW-1");
        this.assertSearchWithResults("reporter changed from " + goodBetty + "", "COW-3", "COW-1");
        this.assertSearchWithResults("reporter changed to " + goodBetty + "", "COW-3", "COW-1");
        this.assertSearchWithResults("reporter changed from bb to " + goodBetty + "", "COW-3");
        this.assertSearchWithResults("reporter changed from " + goodBetty + " to bb", new String[0]);
        this.assertBadValueError("reporter changed from " + goodBetty + " to " + badCandy, "reporter", badCandy);
        this.assertSearchWithResults("reporter changed from " + goodBetty + " to cat", "COW-1");
        this.assertSearchWithResults("reporter changed from " + goodBetty + " to " + goodCandy, "COW-3");
        this.assertSearchWithResults("tester = " + goodCandy, "COW-1");
        this.assertSearchWithResults("cc = " + goodCandy, new String[0]);
        this.assertSearchWithResults("voter = " + goodCandy, "COW-1");
        this.assertSearchWithResults("watcher = " + goodCandy, "COW-2");
        this.assertSearchWithResults("voter = " + goodBetty, "COW-3");
        this.assertSearchWithResults("watcher = " + goodBetty, "COW-4");
        this.assertBadValueWarning("assignee = " + badCandy, "assignee", badCandy);
        this.assertByClauseError("assignee changed by " + badBetty, badBetty);
        this.assertBadValueError("assignee changed to " + badBetty, "assignee", badBetty);
        this.assertBadValueWarning("reporter = " + badCandy, "reporter", badCandy);
        this.assertByClauseError("reporter changed by " + badBetty, badBetty);
        this.assertBadValueError("reporter changed from " + badBetty, "reporter", badBetty);
        this.assertBadValueWarning("tester = " + badCandy, "tester", badCandy);
        this.assertBadValueWarning("cc = " + badCandy, "cc", badCandy);
        this.assertBadValueWarning("voter = " + badCandy, "voter", badCandy);
        this.assertBadValueWarning("watcher = " + badCandy, "watcher", badCandy);
        try {
            this.backdoor.issueTableClient().loginAs(goodBetty, "betty");
            this.assertCurrentUserQueryResultsForBetty();
            this.backdoor.issueTableClient().loginAs(goodCandy, "cc");
            this.assertCurrentUserQueryResultsForCandy();
        }
        finally {
            this.backdoor.issueTableClient().loginAs("admin");
        }
    }

    private void assertCurrentUserQueryResultsForBetty() {
        this.assertSearchWithResults("assignee = currentUser()", "COW-1");
        this.assertSearchWithResults("reporter = currentUser()", new String[0]);
        this.assertSearchWithResults("reporter in (currentUser(), cat)", "COW-2", "COW-1");
        this.assertSearchWithResults("tester = currentUser()", new String[0]);
        this.assertSearchWithResults("cc = currentUser()", "COW-3");
        this.assertSearchWithResults("voter = currentUser()", "COW-3");
        this.assertSearchWithResults("watcher = currentUser()", "COW-4");
    }

    private void assertCurrentUserQueryResultsForCandy() {
        this.assertSearchWithResults("assignee = currentUser()", new String[0]);
        this.assertSearchWithResults("reporter = currentUser()", "COW-3");
        this.assertSearchWithResults("reporter in (currentUser(), cat)", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("tester = currentUser()", "COW-1");
        this.assertSearchWithResults("cc = currentUser()", new String[0]);
        this.assertSearchWithResults("voter = currentUser()", "COW-1");
        this.assertSearchWithResults("watcher = currentUser()", "COW-2");
    }

    public void testChangedFromAndToForAssigneeAndReporter() {
        this.assertSearchWithResults("assignee changed from admin", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("assignee changed from bb", new String[0]);
        this.assertBadValueError("assignee changed from candy", "assignee", "candy");
        this.assertSearchWithResults("assignee changed from cat", new String[0]);
        this.assertSearchWithResults("assignee changed from cc", new String[0]);
        this.assertSearchWithResults("assignee changed to admin", new String[0]);
        this.assertSearchWithResults("assignee changed to bb", "COW-3");
        this.assertBadValueError("assignee changed to candy", "assignee", "candy");
        this.assertSearchWithResults("assignee changed to cat", "COW-2");
        this.assertSearchWithResults("assignee changed to cc", new String[0]);
        this.assertSearchWithResults("assignee changed from admin to cat", "COW-2");
        this.assertSearchWithResults("assignee changed from admin to cc", new String[0]);
        this.assertBadValueError("assignee changed from admin to candy", "assignee", "candy");
        this.assertSearchWithResults("assignee changed from cat to admin", new String[0]);
        this.assertSearchWithResults("assignee changed from cc to admin", new String[0]);
        this.assertSearchWithResults("reporter changed from admin", "COW-3", "COW-2", "COW-1");
        this.assertSearchWithResults("reporter changed from bb", "COW-3");
        this.assertBadValueError("reporter changed from candy", "reporter", "candy");
        this.assertSearchWithResults("reporter changed from cat", new String[0]);
        this.assertSearchWithResults("reporter changed from cc", new String[0]);
        this.assertSearchWithResults("reporter changed to admin", new String[0]);
        this.assertSearchWithResults("reporter changed to bb", "COW-3");
        this.assertBadValueError("reporter changed to candy", "reporter", "candy");
        this.assertSearchWithResults("reporter changed to cat", "COW-2", "COW-1");
        this.assertSearchWithResults("reporter changed to cc", "COW-3");
        this.assertSearchWithResults("reporter changed from admin to cat", "COW-2");
        this.assertBadValueError("reporter changed from admin to candy", "reporter", "candy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVotersAndWatchers(String user1, String user2) {
        try {
            this.navigation.logout();
            this.navigation.login(user1);
            this.navigation.issue().viewIssue("COW-1").toggleVote();
            this.navigation.issue().viewIssue("COW-2").toggleWatch();
            this.navigation.logout();
            this.navigation.login(user2);
            this.navigation.issue().viewIssue("COW-3").toggleVote();
            this.navigation.issue().viewIssue("COW-4").toggleWatch();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin");
        }
    }

    public void testRenameUser() {
        this.initVotersAndWatchers("cc", "betty");
        this.checkBettyAndCandy("betty", "boop", "cc", "candy");
        this.renameUser("cc", "candy");
        this.renameUser("betty", "boop");
        this.checkBettyAndCandy("boop", "betty", "candy", "cc");
    }

    private void renameUser(String oldUsername, String newUsername) {
        this.administration.usersAndGroups().gotoEditUser(oldUsername).setUsername(newUsername).submitUpdate();
        TestUserRenameOnSearch.assertEquals((String)("/secure/admin/user/ViewUser.jspa?name=" + newUsername), (String)this.navigation.getCurrentPage());
        TestUserRenameOnSearch.assertEquals((String)newUsername, (String)this.locator.id("username").getText());
    }

    private void assertByClauseError(String jqlQuery, String badUser) {
        String expectedMessage = "The user '" + badUser + "' does not exist and cannot be used in the 'by' predicate.";
        this.assertSearchWithError(jqlQuery, expectedMessage);
    }

    private void assertBadValueError(String jqlQuery, String badField, String badValue) {
        String expectedMessage = "The value '" + badValue + "' does not exist for the field '" + badField + "'.";
        this.assertSearchWithError(jqlQuery, expectedMessage);
    }

    private void assertBadValueWarning(String jqlQuery, String badField, String badValue) {
        String expectedMessage = "The value '" + badValue + "' does not exist for the field '" + badField + "'.";
        this.assertSearchWithWarning(jqlQuery, expectedMessage);
    }
}

