/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.page.IssueSearchPage;
import com.atlassian.jira.functest.framework.page.ViewIssuePage;
import com.atlassian.jira.functest.framework.page.ViewProfilePage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.table.HtmlTable;
import java.util.Arrays;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER})
public class TestUserRenameOnProfiles
extends FuncTestCase {
    private static final int CFID_CC = 10200;
    private static final int CFID_TESTER = 10300;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("user_rename.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserRenameOnProfiles() throws Exception {
        this.assertCurrentUserProfileNames("admin", "Adam Ant");
        this.assertSpecificUserProfileNames("cc", "Candy Chaos");
        this.assertSpecificUserProfileNames("cat", "Crazy Cat");
        try {
            this.safeLogin("betty", "betty");
            this.assertCurrentUserProfileNames("betty", "Betty Boop");
            this.assertSpecificUserProfileNames("bb", "Bob Belcher");
            this.safeLogin("bb", "bb");
            this.assertCurrentUserProfileNames("bb", "Bob Belcher");
            this.assertSpecificUserProfileNames("betty", "Betty Boop");
            this.assertSpecificUserProfileNames("admin", "Adam Ant");
            this.safeLogin("bb#asdf", "bb#asdf");
            this.navigation.userProfile().gotoCurrentUserProfile();
            this.assertViewProfileNames("bb#asdf", "BB Asdf");
            TestUserRenameOnProfiles.assertTrue((boolean)new ViewProfilePage(this.locator).getChangePasswordLink().endsWith("username=bb%23asdf"));
        }
        finally {
            this.safeLogin("admin", "admin");
        }
    }

    public void testUserHoverLinks() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        TestUserRenameOnProfiles.assertEquals((String)"betty", (String)viewIssuePage.getAssigneeUsername());
        TestUserRenameOnProfiles.assertEquals((String)"cat", (String)viewIssuePage.getReporterUsername());
        TestUserRenameOnProfiles.assertEquals(Arrays.asList("admin", "bb"), viewIssuePage.getCustomFieldRelUsernames(10200));
        TestUserRenameOnProfiles.assertEquals((String)"cc", (String)viewIssuePage.getCustomFieldRelUsername(10300));
        viewIssuePage = this.navigation.issue().viewIssue("COW-3");
        TestUserRenameOnProfiles.assertEquals((String)"bb", (String)viewIssuePage.getAssigneeUsername());
        TestUserRenameOnProfiles.assertEquals((String)"cc", (String)viewIssuePage.getReporterUsername());
        TestUserRenameOnProfiles.assertEquals(Arrays.asList("admin", "betty"), viewIssuePage.getCustomFieldRelUsernames(10200));
        TestUserRenameOnProfiles.assertEquals((String)"cat", (String)viewIssuePage.getCustomFieldRelUsername(10300));
        IssueSearchPage issueSearchPage = this.navigation.issueNavigator().runSearch("");
        HtmlTable searchResultsTable = issueSearchPage.getResultsTable();
        HtmlTable.Row row = searchResultsTable.getRow(2);
        this.assertTableUsername("bb", row, "Assignee");
        this.assertTableUsername("cc", row, "Reporter");
        this.assertTableUsername("cat", row, "Tester");
        this.assertTableUsernames(Arrays.asList("admin", "betty"), row, "CC");
        row = searchResultsTable.getRow(4);
        this.assertTableUsername("betty", row, "Assignee");
        this.assertTableUsername("cat", row, "Reporter");
        this.assertTableUsername("cc", row, "Tester");
        this.assertTableUsernames(Arrays.asList("admin", "bb"), row, "CC");
        this.administration.usersAndGroups().gotoUserBrowser();
        this.tester.clickLinkWithText("bb#asdf");
        this.tester.assertLinkPresentWithText("bb_asdf@example.com");
    }

    public void testUserHoverResults() {
        this.assertUserHoverDetailsForMissingUser("doesnotexist");
        this.assertUserHoverDetails("admin", "Adam Ant", "mlassau@atlassian.com");
        this.assertUserHoverDetails("bb", "Bob Belcher", "bob@example.com");
        this.assertUserHoverDetails("betty", "Betty Boop", "betty@example.com");
        this.assertUserHoverDetails("cat", "Crazy Cat", "cat@example.com");
        this.assertUserHoverDetails("cc", "Candy Chaos", "candy@example.com");
    }

    public void testRenameUser() throws Exception {
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        TestUserRenameOnProfiles.assertEquals((String)"cat", (String)viewIssuePage.getReporterUsername());
        TestUserRenameOnProfiles.assertEquals((String)"cc", (String)viewIssuePage.getCustomFieldRelUsername(10300));
        this.navigation.gotoPage("secure/admin/user/EditUser!default.jspa?editName=cc");
        this.tester.setFormElement("username", "candy");
        this.tester.submit("Update");
        TestUserRenameOnProfiles.assertEquals((String)"/secure/admin/user/ViewUser.jspa?name=candy", (String)this.navigation.getCurrentPage());
        TestUserRenameOnProfiles.assertEquals((String)"candy", (String)this.locator.id("username").getText());
        viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        TestUserRenameOnProfiles.assertEquals((String)"cat", (String)viewIssuePage.getReporterUsername());
        TestUserRenameOnProfiles.assertEquals((String)"candy", (String)viewIssuePage.getCustomFieldRelUsername(10300));
        this.navigation.userProfile().gotoUserProfile("candy");
        this.assertViewProfileNames("candy", "Candy Chaos");
        this.assertUserHoverDetailsForMissingUser("cc");
        this.assertUserHoverDetails("candy", "Candy Chaos", "candy@example.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeLogin(String username, String password) {
        try {
            this.navigation.logout();
        }
        finally {
            this.navigation.login(username, password);
        }
    }

    private void gotoUserHover(String username) {
        this.navigation.gotoPage("/secure/ViewUserHover!default.jspa?decorator=none&username=" + username);
    }

    private void assertUserHoverDetailsForMissingUser(String username) {
        this.gotoUserHover(username);
        TestUserRenameOnProfiles.assertFalse((boolean)this.locator.id("avatar-full-name-link").exists());
        TestUserRenameOnProfiles.assertEquals((String)("User does not exist: " + username), (String)this.locator.css("div.user-hover-details").getText());
        TestUserRenameOnProfiles.assertEquals((String)"", (String)this.locator.id("user-hover-email").getText());
    }

    private void assertUserHoverDetails(String username, String fullName, String emailAddress) {
        this.gotoUserHover(username);
        Element link = (Element)this.locator.id("avatar-full-name-link").getNode();
        TestUserRenameOnProfiles.assertEquals((String)username, (String)link.getAttribute("title"));
        TestUserRenameOnProfiles.assertEquals((String)fullName, (String)link.getTextContent().trim());
        TestUserRenameOnProfiles.assertEquals((String)emailAddress, (String)this.locator.id("user-hover-email").getText());
    }

    private void assertCurrentUserProfileNames(String username, String fullname) {
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.assertViewProfileNames(username, fullname);
        TestUserRenameOnProfiles.assertTrue((boolean)new ViewProfilePage(this.locator).getChangePasswordLink().endsWith("username=" + username));
    }

    private void assertSpecificUserProfileNames(String username, String fullname) {
        this.navigation.userProfile().gotoUserProfile(username);
        this.assertViewProfileNames(username, fullname);
    }

    private void assertViewProfileNames(String username, String fullName) {
        ViewProfilePage viewProfilePage = new ViewProfilePage(this.locator);
        TestUserRenameOnProfiles.assertEquals((String)username, (String)viewProfilePage.getUsername());
        TestUserRenameOnProfiles.assertEquals((String)fullName, (String)viewProfilePage.getFullName());
    }

    private void assertTableUsername(String username, HtmlTable.Row row, String heading) {
        Node cellNode = row.getCellNodeForHeading(heading);
        TestUserRenameOnProfiles.assertEquals((String)username, (String)ViewIssuePage.getRelUsername(cellNode));
    }

    private void assertTableUsernames(List<String> usernames, HtmlTable.Row row, String heading) {
        Node cellNode = row.getCellNodeForHeading(heading);
        TestUserRenameOnProfiles.assertEquals(usernames, ViewIssuePage.getRelUsernames(cellNode));
    }
}

