/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.PermissionSchemes;
import com.atlassian.jira.functest.framework.admin.user.EditUserPage;
import com.atlassian.jira.functest.framework.page.ViewIssuePage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.PERMISSIONS})
public class TestUserRenameOnPermissions
extends FuncTestCase {
    public void testSingleUserPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEdit("betty"));
        PermissionSchemes.PermissionScheme permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "10001");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEdit("betty"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToSingleUser(ProjectPermissions.EDIT_ISSUES, "betty");
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEdit("betty"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEdit("bb"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("betty");
        editUserPage.setUsername("betty2");
        editUserPage.submitUpdate();
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEdit("betty2"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEdit("bb"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "bb");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEdit("betty2"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToSingleUser(ProjectPermissions.EDIT_ISSUES, "bb");
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEdit("bb"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEdit("betty2"));
    }

    public void testReporterPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        PermissionSchemes.PermissionScheme permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "10001");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat", "COW-1"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToReporter(ProjectPermissions.EDIT_ISSUES);
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cc", "COW-3"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat", "COW-3"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-3"));
    }

    public void testAssigneePermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        PermissionSchemes.PermissionScheme permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "10001");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("betty", "COW-1"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToCurrentAssignee(ProjectPermissions.EDIT_ISSUES);
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("betty", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("bb", "COW-1"));
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("bb", "COW-3"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("betty", "COW-3"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("betty");
        editUserPage.setUsername("betty2");
        editUserPage.submitUpdate();
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("betty2", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("bb", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("betty2", "COW-3"));
    }

    public void testGroupPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        PermissionSchemes.PermissionScheme permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "10001");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat", "COW-1"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToGroup(ProjectPermissions.EDIT_ISSUES, "jira-developers");
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        this.administration.usersAndGroups().removeUserFromGroup("cat2", "jira-developers");
        this.administration.usersAndGroups().addUserToGroup("cc", "jira-developers");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-1"));
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cc", "COW-1"));
    }

    public void testProjectLeadPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        PermissionSchemes.PermissionScheme permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "10001");
        this.administration.project().setProjectLead("Bovine", "cat");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat", "COW-1"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToProjectLead(ProjectPermissions.EDIT_ISSUES);
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        this.administration.project().setProjectLead("Bovine", "cc");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-1"));
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cc", "COW-1"));
    }

    public void testUserCFPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        PermissionSchemes.PermissionScheme permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "10001");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat", "COW-2"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToUserCustomFieldValue(ProjectPermissions.EDIT_ISSUES, "customfield_10300");
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat", "COW-2"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-2"));
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cc", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat", "COW-1"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-2"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-1"));
    }

    public void testGroupCFPermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        PermissionSchemes.PermissionScheme permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "10001");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat", "COW-5"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToGroupCustomFieldValue(ProjectPermissions.EDIT_ISSUES, "customfield_10400");
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat", "COW-5"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-5"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-5"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-5"));
        this.administration.usersAndGroups().removeUserFromGroup("cat2", "jira-developers");
        this.administration.usersAndGroups().addUserToGroup("cc", "jira-developers");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-5"));
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cc", "COW-5"));
    }

    public void testProjectRolePermission() {
        this.administration.restoreData("user_rename_permissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cat");
        editUserPage.setUsername("cat2");
        editUserPage.submitUpdate();
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        this.administration.usersAndGroups().removeUserFromGroup("cat2", "jira-developers");
        this.administration.usersAndGroups().addUserToGroup("cc", "jira-developers");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-1"));
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cc", "COW-1"));
        PermissionSchemes.PermissionScheme permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "10001");
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToProjectRole(ProjectPermissions.EDIT_ISSUES, "10002");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat2", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "10002");
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToProjectRole(ProjectPermissions.EDIT_ISSUES, "10003");
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat2", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        editUserPage = this.administration.usersAndGroups().gotoEditUser("cat2");
        editUserPage.setUsername("cat");
        editUserPage.submitUpdate();
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cat", "COW-1"));
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cc", "COW-1"));
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.removePermission(ProjectPermissions.EDIT_ISSUES, "10003");
        permissionScheme = this.administration.permissionSchemes().defaultScheme();
        permissionScheme.grantPermissionToProjectRole(ProjectPermissions.EDIT_ISSUES, "10004");
        TestUserRenameOnPermissions.assertFalse((boolean)this.userCanEditIssue("cat", "COW-1"));
        TestUserRenameOnPermissions.assertTrue((boolean)this.userCanEditIssue("cc", "COW-1"));
    }

    private boolean userCanEdit(String username) {
        return this.userCanEditIssue(username, "COW-1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean userCanEditIssue(String username, String issueKey) {
        String password = username;
        if (username.equals("betty2")) {
            password = "betty";
        }
        if (username.equals("cat2")) {
            password = "cat";
        }
        try {
            this.navigation.login(username, password);
            ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue(issueKey);
            boolean bl = viewIssuePage.containsEditButton();
            return bl;
        }
        finally {
            this.navigation.login("admin");
        }
    }
}

