/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.user.EditUserPage;
import com.atlassian.jira.functest.framework.page.IssueSearchPage;
import com.atlassian.jira.functest.framework.page.ManageWatchersPage;
import com.atlassian.jira.functest.framework.page.ViewIssuePage;
import com.atlassian.jira.functest.framework.page.ViewVotersPage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.table.HtmlTable;
import java.util.Arrays;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.ISSUES, Category.ISSUE_NAVIGATOR})
public class TestUserRenameOnIssues
extends FuncTestCase {
    private static final int ISSUE_COW_2 = 10100;
    private static final int ISSUE_COW_3 = 10101;
    private static final int ISSUE_COW_4 = 10200;
    private static final int CF_CC = 10200;
    private static final int CF_TESTER = 10300;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("user_rename.xml");
    }

    public void testUserRenameOnIssues() throws Exception {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        TestUserRenameOnIssues.assertEquals((String)"Betty Boop", (String)viewIssuePage.getAssignee());
        TestUserRenameOnIssues.assertEquals((String)"Crazy Cat", (String)viewIssuePage.getReporter());
        TestUserRenameOnIssues.assertEquals((String)"Adam Ant, Bob Belcher", (String)viewIssuePage.getCustomFieldValue(10200));
        TestUserRenameOnIssues.assertEquals((String)"Candy Chaos", (String)viewIssuePage.getCustomFieldValue(10300));
        viewIssuePage = this.navigation.issue().viewIssue("COW-3");
        TestUserRenameOnIssues.assertEquals((String)"Bob Belcher", (String)viewIssuePage.getAssignee());
        TestUserRenameOnIssues.assertEquals((String)"Candy Chaos", (String)viewIssuePage.getReporter());
        TestUserRenameOnIssues.assertEquals((String)"Adam Ant, Betty Boop", (String)viewIssuePage.getCustomFieldValue(10200));
        TestUserRenameOnIssues.assertEquals((String)"Crazy Cat", (String)viewIssuePage.getCustomFieldValue(10300));
        IssueSearchPage issueSearchPage = this.navigation.issueNavigator().runSearch("");
        System.out.println("getCurrentPage() = " + this.navigation.getCurrentPage());
        HtmlTable searchResultsTable = issueSearchPage.getResultsTable();
        TestUserRenameOnIssues.assertEquals((String)"COW-3", (String)searchResultsTable.getRow(2).getCellForHeading("Key"));
        TestUserRenameOnIssues.assertEquals((String)"Bob Belcher", (String)searchResultsTable.getRow(2).getCellForHeading("Assignee"));
        TestUserRenameOnIssues.assertEquals((String)"Candy Chaos", (String)searchResultsTable.getRow(2).getCellForHeading("Reporter"));
        TestUserRenameOnIssues.assertEquals((String)"Crazy Cat", (String)searchResultsTable.getRow(2).getCellForHeading("Tester"));
        TestUserRenameOnIssues.assertEquals((String)"Adam Ant, Betty Boop", (String)searchResultsTable.getRow(2).getCellForHeading("CC"));
        TestUserRenameOnIssues.assertEquals((String)"COW-1", (String)searchResultsTable.getRow(4).getCellForHeading("Key"));
        TestUserRenameOnIssues.assertEquals((String)"Betty Boop", (String)searchResultsTable.getRow(4).getCellForHeading("Assignee"));
        TestUserRenameOnIssues.assertEquals((String)"Crazy Cat", (String)searchResultsTable.getRow(4).getCellForHeading("Reporter"));
        TestUserRenameOnIssues.assertEquals((String)"Candy Chaos", (String)searchResultsTable.getRow(4).getCellForHeading("Tester"));
        TestUserRenameOnIssues.assertEquals((String)"Adam Ant, Bob Belcher", (String)searchResultsTable.getRow(4).getCellForHeading("CC"));
    }

    private void doWatchAndVoteAsBetty() throws Exception {
        this.navigation.logout();
        this.navigation.login("betty");
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-3");
        TestUserRenameOnIssues.assertEquals((int)0, (int)viewIssuePage.getVoteCount());
        viewIssuePage = viewIssuePage.toggleVote();
        TestUserRenameOnIssues.assertEquals((int)1, (int)viewIssuePage.getVoteCount());
        TestUserRenameOnIssues.assertEquals((boolean)true, (boolean)viewIssuePage.hasVoted());
        viewIssuePage = viewIssuePage.toggleVote();
        TestUserRenameOnIssues.assertEquals((int)0, (int)viewIssuePage.getVoteCount());
        TestUserRenameOnIssues.assertEquals((boolean)false, (boolean)viewIssuePage.hasVoted());
        viewIssuePage = viewIssuePage.toggleVote();
        TestUserRenameOnIssues.assertEquals((int)1, (int)viewIssuePage.getWatcherCount());
        viewIssuePage = viewIssuePage.toggleWatch();
        TestUserRenameOnIssues.assertEquals((int)2, (int)viewIssuePage.getWatcherCount());
        TestUserRenameOnIssues.assertEquals((boolean)true, (boolean)viewIssuePage.isWatching());
        viewIssuePage = this.navigation.issue().viewIssue("COW-2");
        TestUserRenameOnIssues.assertEquals((boolean)true, (boolean)viewIssuePage.isWatching());
        TestUserRenameOnIssues.assertEquals((int)3, (int)viewIssuePage.getWatcherCount());
        viewIssuePage = viewIssuePage.toggleWatch();
        TestUserRenameOnIssues.assertEquals((int)2, (int)viewIssuePage.getWatcherCount());
        TestUserRenameOnIssues.assertEquals((boolean)false, (boolean)viewIssuePage.isWatching());
        viewIssuePage.toggleVote();
    }

    private void doWatchAndVoteAsBob() throws Exception {
        this.navigation.logout();
        this.navigation.login("bb");
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-4");
        TestUserRenameOnIssues.assertEquals((int)0, (int)viewIssuePage.getVoteCount());
        viewIssuePage = viewIssuePage.toggleVote();
        TestUserRenameOnIssues.assertEquals((int)1, (int)viewIssuePage.getVoteCount());
        TestUserRenameOnIssues.assertEquals((boolean)true, (boolean)viewIssuePage.hasVoted());
        viewIssuePage = viewIssuePage.toggleVote();
        TestUserRenameOnIssues.assertEquals((int)0, (int)viewIssuePage.getVoteCount());
        TestUserRenameOnIssues.assertEquals((boolean)false, (boolean)viewIssuePage.hasVoted());
        viewIssuePage = viewIssuePage.toggleVote();
        TestUserRenameOnIssues.assertEquals((int)1, (int)viewIssuePage.getWatcherCount());
        viewIssuePage = viewIssuePage.toggleWatch();
        TestUserRenameOnIssues.assertEquals((int)2, (int)viewIssuePage.getWatcherCount());
        TestUserRenameOnIssues.assertEquals((boolean)true, (boolean)viewIssuePage.isWatching());
        viewIssuePage = this.navigation.issue().viewIssue("COW-2");
        TestUserRenameOnIssues.assertEquals((boolean)true, (boolean)viewIssuePage.isWatching());
        TestUserRenameOnIssues.assertEquals((int)2, (int)viewIssuePage.getWatcherCount());
        viewIssuePage = viewIssuePage.toggleWatch();
        TestUserRenameOnIssues.assertEquals((int)1, (int)viewIssuePage.getWatcherCount());
        TestUserRenameOnIssues.assertEquals((boolean)false, (boolean)viewIssuePage.isWatching());
        viewIssuePage.toggleVote();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWatchersAndVoters() throws Exception {
        ManageWatchersPage manageWatchersPage = this.navigation.gotoPageWithParams(ManageWatchersPage.class, "id=10100");
        List<String> watchers = manageWatchersPage.getCurrentWatchers();
        TestUserRenameOnIssues.assertEquals(Arrays.asList("Adam Ant (admin)"), watchers);
        manageWatchersPage = manageWatchersPage.addWatchers("betty");
        watchers = manageWatchersPage.getCurrentWatchers();
        TestUserRenameOnIssues.assertEquals(Arrays.asList("Adam Ant (admin)", "Betty Boop (betty)"), watchers);
        manageWatchersPage = manageWatchersPage.addWatchers("bb");
        watchers = manageWatchersPage.getCurrentWatchers();
        TestUserRenameOnIssues.assertEquals(Arrays.asList("Adam Ant (admin)", "Betty Boop (betty)", "Bob Belcher (bb)"), watchers);
        try {
            this.doWatchAndVoteAsBetty();
            this.doWatchAndVoteAsBob();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin");
        }
        TestUserRenameOnIssues.assertEquals(Arrays.asList("Betty Boop (betty)", "Bob Belcher (bb)"), this.votersFor(10100));
        TestUserRenameOnIssues.assertEquals(Arrays.asList("Betty Boop (betty)"), this.votersFor(10101));
        TestUserRenameOnIssues.assertEquals(Arrays.asList("Bob Belcher (bb)"), this.votersFor(10200));
    }

    public void testVotingOnOwnIssue() throws Exception {
        this.navigation.login("cat");
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue("COW-2");
        TestUserRenameOnIssues.assertFalse((String)"Renamed user shouldn't be able to vote on its own issue", (boolean)viewIssuePage.canVote());
        viewIssuePage = this.navigation.issue().viewIssue("COW-3");
        TestUserRenameOnIssues.assertTrue((String)"Renamed user should be able to vote on someone else's issue", (boolean)viewIssuePage.canVote());
        this.navigation.logout();
        this.navigation.login("cc");
        viewIssuePage = this.navigation.issue().viewIssue("COW-3");
        TestUserRenameOnIssues.assertFalse((String)"Recycled user shouldn't be able to vote on its own issue", (boolean)viewIssuePage.canVote());
        viewIssuePage = this.navigation.issue().viewIssue("COW-2");
        TestUserRenameOnIssues.assertTrue((String)"Recycled user should be able to vote on someone else's issue", (boolean)viewIssuePage.canVote());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRenameUser() throws Exception {
        ViewIssuePage viewIssuePage;
        try {
            this.navigation.logout();
            this.navigation.login("cc");
            viewIssuePage = this.navigation.issue().viewIssue("COW-4");
            viewIssuePage = viewIssuePage.toggleVote();
            viewIssuePage.toggleWatch();
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin");
        }
        viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        TestUserRenameOnIssues.assertEquals((String)"Crazy Cat", (String)viewIssuePage.getReporter());
        TestUserRenameOnIssues.assertEquals((String)"Candy Chaos", (String)viewIssuePage.getCustomFieldValue(10300));
        TestUserRenameOnIssues.assertEquals(Arrays.asList("Candy Chaos (cc)"), this.votersFor(10200));
        TestUserRenameOnIssues.assertEquals(Arrays.asList("Adam Ant (admin)", "Candy Chaos (cc)"), this.watchersFor(10200));
        EditUserPage editUserPage = this.administration.usersAndGroups().gotoEditUser("cc");
        editUserPage.setUsername("candy");
        editUserPage.submitUpdate();
        TestUserRenameOnIssues.assertEquals((String)"/secure/admin/user/ViewUser.jspa?name=candy", (String)this.navigation.getCurrentPage());
        TestUserRenameOnIssues.assertEquals((String)"candy", (String)this.locator.id("username").getText());
        viewIssuePage = this.navigation.issue().viewIssue("COW-1");
        TestUserRenameOnIssues.assertEquals((String)"Crazy Cat", (String)viewIssuePage.getReporter());
        TestUserRenameOnIssues.assertEquals((String)"Candy Chaos", (String)viewIssuePage.getCustomFieldValue(10300));
        TestUserRenameOnIssues.assertEquals(Arrays.asList("Candy Chaos (candy)"), this.votersFor(10200));
        TestUserRenameOnIssues.assertEquals(Arrays.asList("Adam Ant (admin)", "Candy Chaos (candy)"), this.watchersFor(10200));
    }

    public void testRenameUserValidation() throws Exception {
        this.navigation.gotoPage("secure/admin/user/EditUser!default.jspa?editName=cc");
        this.tester.setFormElement("username", "");
        this.tester.submit("Update");
        TestUserRenameOnIssues.assertEquals((String)"You must specify a username.", (String)this.locator.id("user-edit-username-error").getText());
        this.tester.setFormElement("username", "betty");
        this.tester.submit("Update");
        TestUserRenameOnIssues.assertEquals((String)"A user with that username already exists.", (String)this.locator.id("user-edit-username-error").getText());
        this.tester.setFormElement("username", "i<3u");
        this.tester.submit("Update");
        TestUserRenameOnIssues.assertEquals((String)"The username must not contain '<', '>' or '&'.", (String)this.locator.id("user-edit-username-error").getText());
        this.tester.setFormElement("username", "bet>");
        this.tester.submit("Update");
        TestUserRenameOnIssues.assertEquals((String)"The username must not contain '<', '>' or '&'.", (String)this.locator.id("user-edit-username-error").getText());
        this.tester.setFormElement("username", "yes&no");
        this.tester.submit("Update");
        TestUserRenameOnIssues.assertEquals((String)"The username must not contain '<', '>' or '&'.", (String)this.locator.id("user-edit-username-error").getText());
    }

    private List<String> watchersFor(int issueId) {
        return this.navigation.gotoPageWithParams(ManageWatchersPage.class, "id=" + issueId).getCurrentWatchers();
    }

    private List<String> votersFor(int issueId) {
        return this.navigation.gotoPageWithParams(ViewVotersPage.class, "id=" + issueId).getCurrentVoters();
    }
}

