/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.PROJECTS})
public class TestUserRenameOnDashboards
extends FuncTestCase {
    public static final String CHANGE_OWNERSHIP_OF_DEVELOPERS_DASHBOARD_URL = "secure/admin/dashboards/ChangeSharedDashboardOwner!default.jspa?dashboardId=10014&returnUrl=ViewSharedDashboards.jspa";
    public static final String CHANGE_OWNERSHIP_OF_FREDS_DASHBOARD_URL = "secure/admin/dashboards/ChangeSharedDashboardOwner!default.jspa?dashboardId=10019&returnUrl=ViewSharedDashboards.jspa";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestSharedDashboards.xml");
    }

    public void testDashboardsSharedWithRenamedUser() {
        this.renameUser("anotherdev", "someotherdev");
        this.backdoor.usersAndGroups().addUser("anotherdev");
        this.backdoor.projectRole().deleteGroup("HSP", "Users", "jira-users");
        this.backdoor.projectRole().deleteGroup("MKY", "Users", "jira-users");
        this.navigation.login("someotherdev", "anotherdev");
        this.navigation.dashboard().navigateToPopular();
        this.tester.assertElementPresent("pp_10016");
        this.tester.assertElementPresent("pp_10015");
        this.navigation.login("anotherdev");
        this.navigation.dashboard().navigateToPopular();
        this.tester.assertElementNotPresent("pp_10016");
        this.tester.assertElementNotPresent("pp_10015");
    }

    public void testRenamedUserRetainsDashboardOwnership() {
        this.renameUser("developer", "code monkey");
        this.renameUser("fred", "developer");
        this.navigation.login("code monkey", "developer");
        this.navigation.dashboard().navigateToMy();
        this.tester.assertElementPresent("pp_10012");
        this.tester.assertElementPresent("pp_10016");
        this.navigation.dashboard().navigateToPopular();
        this.text.assertTextPresent(this.locator.css("#pp_10013 > .cell-type-user"), "Developer");
        this.text.assertTextPresent(this.locator.css("#pp_10019 > .cell-type-user"), "Fred Normal");
        this.navigation.dashboard().navigateToFavourites();
        this.text.assertTextPresent(this.locator.css("#pp_10014 > .cell-type-user"), "Developer");
        this.navigation.login("developer", "fred");
        this.navigation.dashboard().navigateToFavourites();
        this.text.assertTextPresent(this.locator.css("#pp_10019 > .cell-type-user"), "Fred Normal");
        this.navigation.login("admin");
        this.navigation.dashboard().navigateToSearch();
        this.tester.setFormElement("searchOwnerUserName", "code monkey");
        this.tester.submit("Search");
        this.text.assertTextPresent(this.locator.css("#pp_10013 > .cell-type-user"), "Developer");
        this.text.assertTextPresent(this.locator.css("#pp_10014 > .cell-type-user"), "Developer");
        this.tester.setFormElement("searchOwnerUserName", "developer");
        this.tester.submit("Search");
        this.text.assertTextPresent(this.locator.css("#pp_10018 > .cell-type-user"), "Fred Normal");
        this.text.assertTextPresent(this.locator.css("#pp_10019 > .cell-type-user"), "Fred Normal");
        this.tester.submit("Search");
        this.tester.assertElementNotPresent("pp_10013");
    }

    public void testOwnershipChangeToRenamedUser() {
        this.renameUser("developer", "code monkey");
        this.renameUser("fred", "developer");
        this.navigation.gotoPage(CHANGE_OWNERSHIP_OF_DEVELOPERS_DASHBOARD_URL);
        FormParameterUtil form = new FormParameterUtil(this.tester, "change-owner-form-10014", "ChangeOwner");
        form.addOptionToHtmlSelect("owner", new String[]{"developer", "developer"});
        form.setFormElement("owner", "developer");
        form.submitForm();
        this.navigation.gotoPage("secure/admin/dashboards/ViewSharedDashboards.jspa");
        this.text.assertTextPresent(this.locator.css("#pp_10014 > .cell-type-user"), "Fred Normal");
        this.navigation.gotoPage(CHANGE_OWNERSHIP_OF_FREDS_DASHBOARD_URL);
        form = new FormParameterUtil(this.tester, "change-owner-form-10019", "ChangeOwner");
        form.addOptionToHtmlSelect("owner", new String[]{"code monkey", "code monkey"});
        form.setFormElement("owner", "code monkey");
        form.submitForm();
        this.navigation.gotoPage("secure/admin/dashboards/ViewSharedDashboards.jspa");
        this.text.assertTextPresent(this.locator.css("#pp_10019 > .cell-type-user"), "Developer");
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }
}

