/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.user.DeleteUserPage;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.projects.pageobjects.backdoor.SidebarDarkFeatureControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.webtests.table.HtmlTable;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.PROJECTS})
public class TestUserRenameOnComponent
extends FuncTestCase {
    private SidebarDarkFeatureControl sidebarDarkFeatureControl;
    private boolean sidebarWasEnabled;
    private static final String LEAN_MEAN_ID = "10100";
    private static final String SMALL_RATTY_ID = "10000";
    private static final String BIG_WUSSY_ID = "10001";
    private static final String WIRY_SKITTISH_ID = "10002";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("user_rename_doggy_components.xml");
        this.sidebarDarkFeatureControl = new SidebarDarkFeatureControl((JIRAEnvironmentData)this.getEnvironmentData());
        this.sidebarWasEnabled = this.sidebarDarkFeatureControl.isEnabledForSite();
        if (this.sidebarWasEnabled) {
            this.sidebarDarkFeatureControl.disableSidebarForSite();
        }
    }

    @Override
    protected void tearDownTest() {
        if (this.sidebarWasEnabled) {
            this.sidebarDarkFeatureControl.enableSidebarForSite();
        }
    }

    public void testJqlFunctionsFindRenamedComponentLeads() {
        HashMap<String, String[]> componentParamMap = new HashMap<String, String[]>();
        componentParamMap.put("components", new String[]{WIRY_SKITTISH_ID});
        String wirySkittishIssueKey = this.navigation.issue().createIssue("Canine", "Task", "Run in circles on the spot", componentParamMap);
        this.renameUser("cat", "crazy");
        this.renameUser("bb", "cat");
        this.navigation.gotoResource("../../../rest/api/2/search?jql=component%20in%20componentsLeadByUser(\"cat\")");
        this.tester.assertTextPresent("\"total\":0");
        this.navigation.gotoResource("../../../rest/api/2/search?jql=component%20in%20componentsLeadByUser(\"crazy\")");
        this.tester.assertTextPresent("\"total\":1");
        this.tester.assertTextPresent(wirySkittishIssueKey);
    }

    public void testRenamedComponentLeadAssignedWhenDefault() {
        this.navigation.issue().goToCreateIssueForm("Canine", null);
        HashMap<String, Object> componentParamMap = new HashMap<String, String[]>();
        componentParamMap.put("components", new String[]{SMALL_RATTY_ID});
        String smallRattyIssueKey = this.navigation.issue().createIssue("Canine", "Task", "Yip in an annoying fashion", componentParamMap);
        this.navigation.issue().gotoIssue(smallRattyIssueKey);
        this.text.assertTextPresent(this.locator.id("assignee-val"), "Bob Belcher");
        this.navigation.issue().goToCreateIssueForm("Canine", null);
        componentParamMap = new HashMap();
        componentParamMap.put("components", new String[]{WIRY_SKITTISH_ID});
        String wirySkittishIssueKey = this.navigation.issue().createIssue("Canine", "Task", "Run in circles on the spot", componentParamMap);
        this.navigation.issue().gotoIssue(wirySkittishIssueKey);
        this.text.assertTextPresent(this.locator.id("assignee-val"), "Crazy Cat");
        this.navigation.issue().goToCreateIssueForm("Canine", null);
        componentParamMap = new HashMap();
        componentParamMap.put("components", new String[]{LEAN_MEAN_ID});
        String leanMeanIssueKey = this.navigation.issue().createIssue("Canine", "Task", "Bite off the postie's arm", componentParamMap);
        this.navigation.issue().gotoIssue(leanMeanIssueKey);
        this.text.assertTextPresent(this.locator.id("assignee-val"), "Candy Chaos");
    }

    public void testRenamedComponentLeadsDisplayedCorrectly() {
        this.assertComponentLeads();
        this.renameUser("bb", "bob");
        this.renameUser("cat", "bb");
        this.assertComponentLeads("betty", "bob", "bb", "cc");
    }

    public void testRenamedComponentLeadElicitsDeletionWarning() {
        String bettysComponent = "Big & Wussy";
        String bbsComponent = "Small & Ratty";
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("bb"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("bb")));
        this.text.assertTextPresent(deleteUserPage.getComponentLink(), "Small & Ratty");
        deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("betty"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("betty")));
        this.text.assertTextPresent(deleteUserPage.getComponentLink(), "Big & Wussy");
        this.renameUser("bb", "belchyman");
        this.renameUser("betty", "bb");
        deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("bb"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("bb")));
        this.text.assertTextPresent(deleteUserPage.getComponentLink(), "Big & Wussy");
        this.text.assertTextNotPresent(deleteUserPage.getComponentLink(), "Small & Ratty");
        deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("belchyman"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("belchyman")));
        this.text.assertTextPresent(deleteUserPage.getComponentLink(), "Small & Ratty");
        this.text.assertTextNotPresent(deleteUserPage.getComponentLink(), "Big & Wussy");
    }

    public void testReferencesToDeletedRenamedComponentLeadRemoved() {
        this.navigation.issue().deleteIssue("COW-3");
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("bb"));
        deleteUserPage.clickDeleteUser();
        this.navigation.gotoPage("browse/DOG?selectedTab=com.atlassian.jira.jira-projects-plugin%3Acomponents-panel");
        HtmlTable componentsTable = this.page.getHtmlTable("components_panel");
        TestUserRenameOnComponent.assertEquals((String)"", (String)componentsTable.getRow(3).getCellAsText(2));
        deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, "returnUrl=UserBrowser.jspa&name=cc");
        deleteUserPage.clickDeleteUser();
        this.navigation.gotoPage("browse/DOG?selectedTab=com.atlassian.jira.jira-projects-plugin%3Acomponents-panel");
        componentsTable = this.page.getHtmlTable("components_panel");
        TestUserRenameOnComponent.assertEquals((String)"", (String)componentsTable.getRow(2).getCellAsText(2));
    }

    private void assertComponentLeads() {
        this.assertComponentLeads("betty", "bb", "cat", "cc");
    }

    private void assertComponentLeads(String bettyUserName, String bobUserName, String crazyUserName, String candyUserName) {
        this.navigation.gotoPage("browse/DOG?selectedTab=com.atlassian.jira.jira-projects-plugin%3Acomponents-panel");
        this.assertComponentAndLeadInBrowseSummaryTable(1, "Big & Wussy", "Betty Boop");
        this.assertComponentAndLeadInBrowseSummaryTable(2, "Lean & Mean", "Candy Chaos");
        this.assertComponentAndLeadInBrowseSummaryTable(3, "Small & Ratty", "Bob Belcher");
        this.assertComponentAndLeadInBrowseSummaryTable(4, "Wiry & Skittish", "Crazy Cat");
        this.navigation.gotoPage("plugins/servlet/project-config/DOG/summary");
        this.assertComponentAndLeadInSummaryList(1, "Big & Wussy", "Betty Boop");
        this.assertComponentAndLeadInSummaryList(2, "Lean & Mean", "Candy Chaos");
        this.assertComponentAndLeadInSummaryList(3, "Small & Ratty", "Bob Belcher");
        this.assertComponentAndLeadInSummaryList(4, "Wiry & Skittish", "Crazy Cat");
        this.navigation.gotoPage("browse/DOG/component/10100");
        this.tester.assertTextInElement("component_summary_" + candyUserName, "Candy Chaos");
        this.navigation.gotoPage("browse/DOG/component/10000");
        this.tester.assertTextInElement("component_summary_" + bobUserName, "Bob Belcher");
        this.navigation.gotoPage("browse/DOG/component/10001");
        this.tester.assertTextInElement("component_summary_" + bettyUserName, "Betty Boop");
        this.navigation.gotoPage("browse/DOG/component/10002");
        this.tester.assertTextInElement("component_summary_" + crazyUserName, "Crazy Cat");
    }

    private void assertComponentAndLeadInBrowseSummaryTable(int position, String expectedComponent, String expectedLead) {
        HtmlTable componentsTable = this.page.getHtmlTable("components_panel");
        TestUserRenameOnComponent.assertEquals((String)expectedComponent, (String)componentsTable.getRow(position).getCellAsText(1));
        TestUserRenameOnComponent.assertEquals((String)expectedLead, (String)componentsTable.getRow(position).getCellAsText(2));
    }

    private void assertComponentAndLeadInSummaryList(int position, String expectedComponent, String expectedLead) {
        XPathLocator componentLocator = new XPathLocator(this.tester, String.format("//ul[@id='project-config-summary-components-list']/li[%d]/span[1]", position));
        XPathLocator nameLocator = new XPathLocator(this.tester, String.format("//ul[@id='project-config-summary-components-list']/li[%d]/span[2]", position));
        TestUserRenameOnComponent.assertTrue((boolean)componentLocator.exists());
        this.text.assertTextPresent(componentLocator, expectedComponent);
        TestUserRenameOnComponent.assertTrue((boolean)nameLocator.exists());
        this.text.assertTextPresent(nameLocator, expectedLead);
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }
}

