/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user.rename;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.table.HtmlTable;
import java.util.HashMap;
import java.util.Map;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.RENAME_USER, Category.ISSUES, Category.ISSUE_NAVIGATOR})
public class TestUserRenameOnChangeHistory
extends FuncTestCase {
    public static final String BROWSE_ISSUE_WITH_HISTORY_URL = "browse/%s?page=com.atlassian.jira.plugin.system.issuetabpanels:changehistory-tabpanel";
    public static final String AUTHOR_ID = "changehistoryauthor_%d";
    public static final String CHANGE_TABLE_ID = "changehistory_%d";
    public static final String SINGLE_USER_FIELD_ID = "customfield_10400";
    public static final String MULTI_USER_FIELD_ID = "customfield_10401";
    public static final String SINGLE_USER_FIELD_NAME = "Single user";
    public static final String MULTI_USER_FIELD_NAME = "Multi user";
    public static final String NOTHING = "";
    public static final String CC_CAT_CHANGE = "Candy Chaos, Crazy Cat [ ID10101, cc ]";
    public static final String RENAMED_CC_CAT_CHANGE = "Candy Chaos, Crazy Cat [ ID10101, cc ]";
    public static final String BB_CRAZY_CANDY = "Betty Boop, Candy Chaos, Crazy Cat [ bb, ID10101, cc ]";
    public static final String ADAM_ANT_SYSTEM_FIELD_DISPLAY = "Adam Ant [ admin ]";
    public static final String CRAZY_CAT_SYSTEM_FIELD_DISPLAY = "Crazy Cat [ cc ]";
    public static final String CANDY_CHAOS_SYSTEM_FIELD_DISPLAY = "Candy Chaos [ ID10101 ]";
    public static final String BOB_BELCHER_SYSTEM_FIELD_DISPLAY = "Bob Belcher [ ID10001 ]";
    public static final String BETTY_BOOP_SYSTEM_FIELD_DISPLAY = "Betty Boop [ bb ]";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("user_rename_customfields.xml");
        this.administration.backdoor().darkFeatures().enableForSite("jira.no.frother.reporter.field");
        this.administration.backdoor().darkFeatures().enableForSite("no.frother.assignee.field");
    }

    public void testCustomFieldChangeAuthorPreservedDespiteRename() {
        this.navigation.login("bb");
        this.navigation.issue().setFreeTextCustomField("COW-2", SINGLE_USER_FIELD_ID, "bb");
        this.navigation.issue().setFreeTextCustomField("COW-2", MULTI_USER_FIELD_ID, "cc, cat");
        this.assertChangeRecordedCorrectly("COW-2", 10800, "Bob Belcher", SINGLE_USER_FIELD_NAME, NOTHING, BOB_BELCHER_SYSTEM_FIELD_DISPLAY);
        this.assertChangeRecordedCorrectly("COW-2", 10801, "Bob Belcher", MULTI_USER_FIELD_ID, NOTHING, "Candy Chaos, Crazy Cat [ ID10101, cc ]");
        this.navigation.login("admin");
        this.renameUser("bb", "belchyman");
        this.assertChangeRecordedCorrectly("COW-2", 10800, "Bob Belcher", SINGLE_USER_FIELD_NAME, NOTHING, BOB_BELCHER_SYSTEM_FIELD_DISPLAY);
        this.assertChangeRecordedCorrectly("COW-2", 10801, "Bob Belcher", MULTI_USER_FIELD_ID, NOTHING, "Candy Chaos, Crazy Cat [ ID10101, cc ]");
        this.navigation.login("betty");
        this.navigation.issue().setFreeTextCustomField("COW-3", SINGLE_USER_FIELD_ID, "cc");
        this.navigation.issue().setFreeTextCustomField("COW-3", MULTI_USER_FIELD_ID, "cc, cat");
        this.assertChangeRecordedCorrectly("COW-3", 10802, "Betty Boop", SINGLE_USER_FIELD_NAME, NOTHING, CANDY_CHAOS_SYSTEM_FIELD_DISPLAY);
        this.assertChangeRecordedCorrectly("COW-3", 10803, "Betty Boop", MULTI_USER_FIELD_NAME, NOTHING, "Candy Chaos, Crazy Cat [ ID10101, cc ]");
        this.navigation.login("admin");
        this.renameUser("betty", "bb");
        this.renameUser("cat", "crazy");
        this.renameUser("cc", "candy");
        this.navigation.issue().setFreeTextCustomField("COW-3", MULTI_USER_FIELD_ID, "bb, crazy, candy");
        this.assertChangeRecordedCorrectly("COW-3", 10802, "Betty Boop", SINGLE_USER_FIELD_NAME, NOTHING, CANDY_CHAOS_SYSTEM_FIELD_DISPLAY);
        this.assertChangeRecordedCorrectly("COW-3", 10803, "Betty Boop", MULTI_USER_FIELD_NAME, NOTHING, "Candy Chaos, Crazy Cat [ ID10101, cc ]");
        this.assertChangeRecordedCorrectly("COW-3", 10804, "Adam Ant", MULTI_USER_FIELD_NAME, "Candy Chaos, Crazy Cat [ ID10101, cc ]", BB_CRAZY_CANDY);
        this.renameUser("crazy", "meow");
        this.navigation.issue().setFreeTextCustomField("COW-3", SINGLE_USER_FIELD_ID, "candy");
        this.navigation.issue().setFreeTextCustomField("COW-3", MULTI_USER_FIELD_ID, "bb, meow, candy");
        TestUserRenameOnChangeHistory.assertFalse((boolean)this.locator.id(String.format(CHANGE_TABLE_ID, 10805)).exists());
    }

    public void testReporterAndAssigneeChangeAuthorPreservedDespiteRename() {
        this.backdoor.usersAndGroups().addUserToGroup("bb", "jira-administrators");
        this.backdoor.usersAndGroups().addUserToGroup("betty", "jira-administrators");
        this.navigation.login("betty");
        this.navigation.issue().gotoEditIssue("COW-4");
        this.tester.setFormElement("assignee", "cat");
        this.tester.setFormElement("reporter", "cc");
        this.tester.submit("Update");
        HashMap<String, Change> expectedChanges = new HashMap<String, Change>();
        expectedChanges.put("Assignee", new Change(ADAM_ANT_SYSTEM_FIELD_DISPLAY, CRAZY_CAT_SYSTEM_FIELD_DISPLAY));
        expectedChanges.put("Reporter", new Change(ADAM_ANT_SYSTEM_FIELD_DISPLAY, CANDY_CHAOS_SYSTEM_FIELD_DISPLAY));
        this.assertChangeRecordedCorrectly("COW-4", 10800, "Betty Boop", expectedChanges);
        this.navigation.login("admin");
        this.renameUser("bb", "belchyman");
        this.renameUser("betty", "bb");
        this.assertChangeRecordedCorrectly("COW-4", 10800, "Betty Boop", expectedChanges);
        this.renameUser("bb", "betty");
        this.renameUser("belchyman", "bb");
        this.navigation.login("bb");
        this.navigation.issue().gotoEditIssue("COW-1");
        this.tester.setFormElement("assignee", "cat");
        this.tester.setFormElement("reporter", "cc");
        this.tester.submit("Update");
        expectedChanges.clear();
        expectedChanges.put("Assignee", new Change(BETTY_BOOP_SYSTEM_FIELD_DISPLAY, CRAZY_CAT_SYSTEM_FIELD_DISPLAY));
        expectedChanges.put("Reporter", new Change(CRAZY_CAT_SYSTEM_FIELD_DISPLAY, CANDY_CHAOS_SYSTEM_FIELD_DISPLAY));
        this.assertChangeRecordedCorrectly("COW-1", 10801, "Bob Belcher", expectedChanges);
        this.navigation.login("admin");
        this.renameUser("cat", "crazy");
        this.renameUser("bb", "belchyman");
        this.renameUser("cc", "candy");
        this.assertChangeRecordedCorrectly("COW-1", 10801, "Bob Belcher", expectedChanges);
        this.navigation.login("belchyman", "bb");
        this.navigation.issue().assignIssue("COW-4", null, "Bob Belcher");
        this.assertChangeRecordedCorrectly("COW-4", 10802, "Bob Belcher", "Assignee", CRAZY_CAT_SYSTEM_FIELD_DISPLAY, BOB_BELCHER_SYSTEM_FIELD_DISPLAY);
        this.navigation.issue().gotoEditIssue("COW-4");
        this.tester.setFormElement("reporter", "belchyman");
        this.tester.submit("Update");
        this.assertChangeRecordedCorrectly("COW-4", 10803, "Bob Belcher", "Reporter", CANDY_CHAOS_SYSTEM_FIELD_DISPLAY, BOB_BELCHER_SYSTEM_FIELD_DISPLAY);
    }

    private void assertChangeRecordedCorrectly(String issueKey, int changeId, String expectedAuthorName, String fieldName, String oldValue, String newValue) {
        HashMap<String, Change> expectedChanges = new HashMap<String, Change>();
        expectedChanges.put(fieldName, new Change(oldValue, newValue));
        this.assertChangeRecordedCorrectly(issueKey, changeId, expectedAuthorName, expectedChanges);
    }

    private void assertChangeRecordedCorrectly(String issueKey, int changeId, String expectedAuthorName, Map<String, Change> changesByFieldName) {
        this.navigation.gotoPage(String.format(BROWSE_ISSUE_WITH_HISTORY_URL, issueKey));
        this.text.assertTextPresent(this.locator.id(String.format(AUTHOR_ID, changeId)), expectedAuthorName);
        HtmlTable changesTable = this.page.getHtmlTable(String.format(CHANGE_TABLE_ID, changeId));
        for (HtmlTable.Row row : changesTable.getRows()) {
            String field = row.getCellAsText(0);
            if (!changesByFieldName.containsKey(field)) continue;
            Change expectedChange = changesByFieldName.get(field);
            String actualOld = row.getCellAsText(1);
            String actualNew = row.getCellAsText(2);
            TestUserRenameOnChangeHistory.assertEquals((String)expectedChange.oldValue, (String)actualOld);
            TestUserRenameOnChangeHistory.assertEquals((String)expectedChange.newValue, (String)actualNew);
        }
    }

    private void renameUser(String from, String to) {
        this.navigation.gotoPage(String.format("secure/admin/user/EditUser!default.jspa?editName=%s", from));
        this.tester.setFormElement("username", to);
        this.tester.submit("Update");
    }

    private static class Change {
        public final String oldValue;
        public final String newValue;

        public Change(String oldValue, String newValue) {
            this.oldValue = oldValue;
            this.newValue = newValue;
        }
    }
}

