/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.BROWSING})
public class TestViewProfile
extends FuncTestCase {
    public static final String PROJECT_MONKEY = "monkey";
    public static final String PROJECT_HOMOSAP = "homosapien";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestViewProfile.xml");
    }

    public void testIssueNavigatorLinkEncoding() throws Exception {
        this.tester.gotoPage("/secure/ViewProfile.jspa?name=monkey%2Bman");
        this.text.assertTextNotPresent(this.tester.getDialog().getResponseText(), "= \"monkey+man\"");
        this.text.assertTextPresent(this.tester.getDialog().getResponseText(), "+%3D+%22monkey%2Bman%22");
    }

    public void testEmailVisibility() {
        this.tester.clickLink("view_profile");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full Name:", "Administrator", "Email:", "admin@example.com", "Groups:"});
        this.tester.assertLinkPresentWithText("admin@example.com");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("emailVisibility", "hide");
        this.tester.submit("Update");
        this.tester.clickLink("view_profile");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full Name:", "Administrator", "Groups:"});
        this.tester.assertTextNotPresent("Email:");
        this.tester.assertLinkNotPresentWithText("admin@example.com");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("emailVisibility", "mask");
        this.tester.submit("Update");
        this.tester.clickLink("view_profile");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full Name:", "Administrator", "Email:", "admin at example dot com", "Groups:"});
        this.tester.assertLinkNotPresentWithText("admin@example.com");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("emailVisibility", "user");
        this.tester.submit("Update");
        this.tester.clickLink("view_profile");
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"Full Name:", "Administrator", "Email:", "admin@example.com", "Groups:"});
        this.tester.assertLinkPresentWithText("admin@example.com");
    }

    public void testAllLinksShow() {
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile");
        this.tester.clickLink("admin_user");
        this.tester.assertTextPresent("jira-administrators");
        this.tester.clickLink("view_profile");
        this.tester.clickLink("view_project_roles");
        Assert.assertThat((Object)this.locator.css(".aui-nav-breadcrumbs a").getNodes()[0].getNodeValue(), (Matcher)Matchers.equalTo((Object)"Users"));
        Assert.assertThat((Object)this.locator.css(".aui-nav-breadcrumbs a").getNodes()[1].getNodeValue(), (Matcher)Matchers.equalTo((Object)"Administrator"));
        Assert.assertThat((Object)this.locator.css(".aui-page-header h2").getText(), (Matcher)Matchers.equalTo((Object)"View Project Roles for User"));
        this.tester.clickLink("view_profile");
        this.tester.clickLink("view_change_password");
        this.tester.assertLinkNotPresent("view_change_password");
    }

    public void testNotOwnProfile() {
        this.tester.gotoPage("/secure/ViewProfile.jspa?name=fred");
        this.tester.assertLinkPresent("view_profile");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertTextNotPresent("Reports");
        this.tester.assertLinkNotPresent("voted");
        this.tester.assertLinkNotPresent("watched");
        this.tester.assertLinkNotPresent("view_change_password");
        this.tester.assertLinkNotPresent("view_dashboard_config");
        this.tester.assertLinkNotPresent("view_manage_filters");
        this.tester.assertLinkNotPresent("edit_prefs_lnk");
        this.tester.assertLinkNotPresent("edit_profile_lnk");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNotLoggedIn() {
        try {
            this.navigation.logout();
            this.tester.gotoPage("/secure/ViewProfile.jspa?name=fred");
            this.tester.assertTextPresent("You must log in to access this page.");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    public void testVotingDisabled() {
        this.setGlobalOption("voting", "false");
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertLinkNotPresent("voted");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("edit_profile_lnk");
        this.tester.assertLinkPresent("view_change_password");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertLinkPresent("watched");
        this.tester.assertLinkPresent("edit_prefs_lnk");
    }

    public void testWatchingDisabled() {
        this.setGlobalOption("watching", "false");
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertLinkNotPresent("watched");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("edit_profile_lnk");
        this.tester.assertLinkPresent("view_change_password");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertLinkPresent("voted");
        this.tester.assertLinkPresent("edit_prefs_lnk");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserNotAdmin() {
        try {
            this.navigation.login("fred", "fred");
            this.navigation.dashboard();
            this.tester.clickLink("view_profile");
            this.tester.assertLinkNotPresent("view_project_roles");
            this.tester.assertLinkNotPresent("admin_user");
            this.tester.assertLinkPresent("edit_profile_lnk");
            this.tester.assertLinkPresent("view_change_password");
            this.tester.assertLinkPresent("voted");
            this.tester.assertLinkPresent("watched");
            this.tester.assertLinkPresent("edit_prefs_lnk");
        }
        finally {
            this.navigation.login("admin", "admin");
        }
    }

    public void testExternalUserManagementEnabled() {
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.navigation.dashboard();
        this.tester.clickLink("view_profile");
        this.tester.assertLinkNotPresent("edit_profile_lnk");
        this.tester.assertLinkNotPresent("view_change_password");
        this.tester.assertLinkPresent("view_project_roles");
        this.tester.assertLinkPresent("admin_user");
        this.tester.assertLinkPresent("voted");
        this.tester.assertLinkPresent("watched");
        this.tester.assertLinkPresent("edit_prefs_lnk");
    }

    public void testAssignedOpenIssuesReport() {
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile: Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per Project");
        this.tester.assertTextPresent("You have no open issues assigned to you");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextPresent("User Profile: Fred Normal");
        this.tester.assertTextNotPresent("Assigned Open Issues per Project");
        this.navigation.issue().createIssue(PROJECT_HOMOSAP, "Bug", "First issue");
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile: Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per Project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextPresent("User Profile: Fred Normal");
        this.tester.assertTextNotPresent("Assigned Open Issues per Project");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=admin");
        this.tester.assertTextPresent("User Profile: Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per Project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.navigation.logout();
        this.navigation.login("admin", "admin");
        this.navigation.issue().createIssue(PROJECT_MONKEY, "Bug", "Second issue");
        this.tester.clickLink("view_profile");
        this.tester.assertTextPresent("User Profile: Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per Project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.tester.assertLinkPresentWithText(PROJECT_MONKEY);
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"1", PROJECT_HOMOSAP, "1", PROJECT_MONKEY});
        this.tester.gotoPage("secure/ViewProfile.jspa?name=fred");
        this.tester.assertTextPresent("User Profile: Fred Normal");
        this.tester.assertTextNotPresent("Assigned Open Issues per Project");
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("secure/ViewProfile.jspa?name=admin");
        this.tester.assertTextPresent("User Profile: Administrator");
        this.tester.assertTextPresent("Assigned Open Issues per Project");
        this.tester.assertLinkPresentWithText(PROJECT_HOMOSAP);
        this.tester.assertLinkPresentWithText(PROJECT_MONKEY);
        this.text.assertTextSequence(new WebPageLocator(this.tester), new String[]{"1", PROJECT_HOMOSAP, "1", PROJECT_MONKEY});
    }

    public void testEditProfileFieldsExceed255() throws Exception {
        this.tester.gotoPage("secure/EditProfile!default.jspa?username=admin");
        String fullname = StringUtils.repeat((String)"ABCDEFGH", (int)32);
        String email = StringUtils.repeat((String)"x", (int)246) + "@email.com";
        this.tester.setFormElement("fullName", fullname);
        this.tester.setFormElement("email", email);
        this.tester.submit();
        this.tester.assertTextPresent("The full name must not exceed 255 characters in length.");
        this.tester.assertTextPresent("The email address must not exceed 255 characters in length.");
        this.tester.setFormElement("fullName", fullname.substring(0, 255));
        this.tester.setFormElement("email", email.substring(0, 255));
        this.tester.submit();
        this.tester.assertTextNotPresent("The full name must not exceed 255 characters in length.");
        this.tester.assertTextNotPresent("The email address must not exceed 255 characters in length.");
    }

    private void setGlobalOption(String optionName, String value) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.setFormElement("title", "jWebTest JIRA installation");
        this.tester.checkCheckbox(optionName, value);
        this.tester.submit("Update");
    }

    public void testAdminLink() {
        this.tester.clickLink("view_profile");
        this.tester.clickLink("admin_user");
        this.assertions.assertNodeByIdHasText("username", "admin");
        this.tester.clickLink("view_profile");
        this.tester.clickLink("view_project_roles");
        this.assertions.assertNodeByIdHasText("return_link", "Administrator");
        this.navigation.userProfile().gotoUserProfile("fred");
        this.tester.clickLink("admin_user");
        this.assertions.assertNodeByIdHasText("username", "fred");
        this.navigation.userProfile().gotoUserProfile("fred");
        this.tester.clickLink("view_project_roles");
        this.assertions.assertNodeByIdHasText("return_link", "Fred Normal");
    }
}

