/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.IssueSecurityLevel;
import com.atlassian.jira.functest.framework.admin.NotificationSchemes;
import com.atlassian.jira.functest.framework.admin.NotificationType;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.FILTERS})
public class TestViewGroup
extends FuncTestCase {
    public static final int CREATE_SHARED_FILTER = 22;
    private static final String TEST_GROUP = "test_group";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testGroupSharedFiltersReported() {
        this.gotoViewGroup("jira-users");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "table.aui td"), "There are no Saved Filters associated with this Group.");
        this.administration.addGlobalPermission(22, "jira-users");
        long adminId = Long.parseLong(this.backdoor.filters().createFilter("", "AdministratorFilter", "admin", "jira-users"));
        long fredId = Long.parseLong(this.backdoor.filters().createFilter("", "FredFilter", "fred", "jira-users"));
        this.gotoViewGroup("jira-users");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "table.aui td"), "AdministratorFilter (Owner: Administrator)");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "table.aui td"), "FredFilter (Owner: Fred Normal)");
        this.navigation.manageFilters().deleteFilter((int)adminId);
        this.gotoViewGroup("jira-users");
        this.assertions.assertNodeDoesNotHaveText(new CssLocator(this.tester, "table.aui td"), "AdministratorFilter (Owner: Administrator)");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "table.aui td"), "FredFilter (Owner: Fred Normal)");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.manageFilters().deleteFilter((int)fredId);
        this.navigation.logout();
        this.navigation.login("admin");
        this.gotoViewGroup("jira-users");
        this.assertions.assertNodeDoesNotHaveText(new CssLocator(this.tester, "table.aui td"), "AdministratorFilter (Owner: Administrator)");
        this.assertions.assertNodeDoesNotHaveText(new CssLocator(this.tester, "table.aui td"), "FredFilter (Owner: Fred Normal)");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, "table.aui td"), "There are no Saved Filters associated with this Group.");
    }

    public void testViewSchemes() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", TEST_GROUP);
        this.tester.submit("add_group");
        this.tester.clickLinkWithText(TEST_GROUP);
        this.text.assertTextPresent(this.locator.page(), "There are no Permission Schemes associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Notification Schemes associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Saved Filters associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Issue Security Schemes associated with this Group.");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.ADMINISTER_PROJECTS.permissionKey(), TEST_GROUP);
        ((NotificationSchemes)this.administration.notificationSchemes().goTo()).editNotifications(10000).addNotificationsForEvent(1, NotificationType.GROUP, TEST_GROUP);
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.administration.issueSecuritySchemes().newScheme("Test Issue Security Scheme", "").newLevel("Code Red", "").addIssueSecurity(IssueSecurityLevel.IssueSecurity.GROUP, TEST_GROUP);
        this.gotoViewGroup(TEST_GROUP);
        this.text.assertTextPresent(this.locator.page(), "Default Permission Scheme");
        this.text.assertTextPresent(this.locator.page(), "Default Notification Scheme");
        this.text.assertTextPresent(this.locator.page(), "Test Issue Security Scheme");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLink("10000_edit");
        this.tester.clickLink("del_10160");
        this.tester.submit("Delete");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLink("0_edit");
        this.tester.clickLink("del_perm_" + ProjectPermissions.ADMINISTER_PROJECTS.permissionKey() + "_test_group");
        this.tester.submit("Delete");
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLink("del_Test Issue Security Scheme");
        this.tester.submit("Delete");
        this.gotoViewGroup(TEST_GROUP);
        this.text.assertTextPresent(this.locator.page(), "There are no Permission Schemes associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Notification Schemes associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Saved Filters associated with this Group.");
        this.text.assertTextPresent(this.locator.page(), "There are no Issue Security Schemes associated with this Group.");
    }

    private void gotoViewGroup(String group) {
        this.tester.gotoPage("secure/admin/user/ViewGroup.jspa?name=" + group);
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header-main .aui-nav-breadcrumbs a"), "Groups");
        this.assertions.assertNodeHasText(new CssLocator(this.tester, ".aui-page-header-main h2"), group);
    }
}

