/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.WebTesterFactory;
import java.text.DecimalFormat;
import net.sourceforge.jwebunit.WebTester;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestUserSessions
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestUserSessions.xml");
    }

    public void testSessionsAppear() {
        this.startSessionsForUsers(1, 150);
        this.gotoUserSessions();
        this.assertLinkPresent("gotoNext", "gotoEnd");
        this.assertLinkNotPresent("gotoStart", "gotoPrev");
        this.tester.clickLink("gotoNext");
        this.assertLinkPresent("gotoStart", "gotoPrev", "gotoNext", "gotoEnd");
        this.tester.clickLink("gotoPrev");
        this.assertLinkPresent("gotoNext", "gotoEnd");
        this.assertLinkNotPresent("gotoStart", "gotoPrev");
        this.tester.clickLink("gotoEnd");
        this.assertLinkPresent("gotoStart", "gotoPrev");
        this.assertLinkNotPresent("gotoEnd", "gotoNext");
    }

    public void testNotAccessibleForAdmin() {
        this.navigation.login("justadmin");
        this.tester.gotoPage("/secure/admin/CurrentUsersList.jspa");
        this.assertions.getJiraFormAssertions().assertFormWarningMessage("'Just Admin' does not have permission to access this page.");
    }

    private void assertLinkPresent(String ... args) {
        for (String arg : args) {
            this.tester.assertLinkPresent(arg);
        }
    }

    private void assertLinkNotPresent(String ... args) {
        for (String arg : args) {
            this.tester.assertLinkNotPresent(arg);
        }
    }

    private void startSessionsForUsers(int start, int end) {
        for (int i = start; i <= end; ++i) {
            this.loginAs(this.makeUserName(i));
        }
    }

    private void loginAs(String userName) {
        WebTester tester = WebTesterFactory.createNewWebTester(this.environmentData);
        tester.beginAt("/login.jsp");
        tester.setFormElement("os_username", userName);
        tester.setFormElement("os_password", userName);
        tester.setWorkingForm("login-form");
        tester.submit();
        this.log.log((Object)("Started session for " + userName));
    }

    private void gotoUserSessions() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USERSESSIONS);
    }

    private String makeUserName(int j) {
        return "user-" + new DecimalFormat("000").format(j);
    }
}

