/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.collect.ImmutableList;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS, Category.REFERENCE_PLUGIN})
public class TestUserProfile
extends FuncTestCase {
    private static final String XSS_ALERT_RAW = "\"alert('surprise!')";
    private static final String XSS_ALERT_ESCAPED = "&quot;alert(&#39;surprise!&#39;)";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testXssInAvatarPicker() {
        this.administration.usersAndGroups().addUser(XSS_ALERT_RAW, "password", XSS_ALERT_RAW, "xss@xss.com");
        this.navigation.login(XSS_ALERT_RAW, "password");
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.assertions.getTextAssertions().assertTextPresent(XSS_ALERT_ESCAPED);
        this.assertions.getTextAssertions().assertTextNotPresent(XSS_ALERT_RAW);
    }

    public void testUrlPropertyRendersAsLink() {
        ImmutableList links = ImmutableList.of((Object)"http://www.atlassian.com/uniqueLinkForThisTest", (Object)"www.atlassian-func-tests.com");
        for (int i = 0; i < links.size(); ++i) {
            String link = (String)links.get(i);
            this.addUserProperty("homePage" + i, link);
            this.navigation.userProfile().gotoCurrentUserProfile();
            this.assertions.getLinkAssertions().assertLinkLocationEndsWith(link, link);
        }
    }

    public void testBadUrlPropertyDoesNotRenderAsLink() {
        String linkUrl = "htp:/bad.url.com";
        this.addUserProperty("homePage", "htp:/bad.url.com");
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.tester.assertLinkNotPresentWithText("htp:/bad.url.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUserChangePassword() {
        try {
            this.navigation.userProfile().gotoCurrentUserProfile();
            this.tester.clickLinkWithText("Change Password");
            this.tester.setFormElement("current", "");
            this.tester.setFormElement("password", "");
            this.tester.setFormElement("confirm", "");
            this.tester.submit();
            this.text.assertTextPresent(this.locator.page(), "The current password specified is incorrect.");
            this.text.assertTextPresent(this.locator.page(), "The new password cannot be blank.");
            this.tester.setFormElement("current", "invalid");
            this.tester.setFormElement("password", "password");
            this.tester.setFormElement("confirm", "mismatch");
            this.tester.submit();
            this.text.assertTextPresent(this.locator.page(), "The current password specified is incorrect.");
            this.text.assertTextPresent(this.locator.page(), "The password and confirmation do not match.");
            String newPassword = "newpassword";
            this.tester.setFormElement("current", "admin");
            this.tester.setFormElement("password", "newpassword");
            this.tester.setFormElement("confirm", "newpassword");
            this.tester.submit();
            this.text.assertTextPresent(this.locator.page(), "Your password has successfully been changed");
            this.navigation.logout();
            this.navigation.loginAttempt("admin", "admin");
            this.text.assertTextPresent(this.locator.page(), "Sorry, your username and password are incorrect - please try again.");
            this.navigation.login("admin", "newpassword");
            TestUserProfile.assertEquals((String)"Administrator", (String)this.navigation.userProfile().userName());
        }
        finally {
            this.administration.restoreBlankInstance();
        }
    }

    public void testShowsLanguageListInDefaultLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.text.assertTextPresent(this.locator.id("up-p-locale"), "Deutsch (Deutschland) [Standard]");
        this.tester.clickLink("edit_prefs_lnk");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("userLocale", "Deutsch (Deutschland) [Standard]");
    }

    public void testShowsLanguageListInTheUsersLanguage() {
        this.administration.restoreData("TestUserProfileI18n.xml");
        this.administration.generalConfiguration().setJiraLocale("Deutsch (Deutschland)");
        this.navigation.login("fred");
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.text.assertTextPresent(this.locator.id("up-p-locale"), "espa\u00f1ol (Espa\u00f1a)");
        this.tester.clickLink("edit_prefs_lnk");
        this.assertions.getJiraFormAssertions().assertSelectElementHasOptionSelected("userLocale", "espa\u00f1ol (Espa\u00f1a)");
    }

    public void testChangeUserProfileRequiresPassword() {
        String newFullName = "New FullName";
        String newEmail = "newemail@example.com";
        this.updateUserProfileForm("admin", "New FullName", "newemail@example.com", "wrongpassword");
        this.tester.assertTextPresent("The password you entered is incorrect.");
        this.updateUserProfileForm("admin", "New FullName", "newemail@example.com", "");
        this.tester.assertTextPresent("The password you entered is incorrect.");
        this.updateUserProfileForm("admin", "New FullName", "newemail@example.com", "admin");
        this.text.assertTextSequence(this.locator.page(), "Profile", "New FullName", "Full Name", "New FullName", "Email", "newemail@example.com");
    }

    public void testWebItemsInOperationsProperlyStyled() {
        this.navigation.userProfile().gotoCurrentUserProfile();
        this.tester.assertTextPresent("Tools");
        Node node = this.locator.css(".reference-web-item-test-class").getNode();
        TestUserProfile.assertEquals((String)node.getAttributes().getNamedItem("id").getNodeValue(), (String)"com.atlassian.jira.dev.reference-plugin:reference-item-user-profile-operations");
    }

    private void updateUserProfileForm(String userName, String fullName, String email, String password) {
        this.tester.gotoPage("secure/EditProfile!default.jspa?username=" + userName);
        this.tester.setFormElement("fullName", fullName);
        this.tester.setFormElement("email", email);
        this.tester.setFormElement("password", password);
        this.tester.submit();
    }

    private void addUserProperty(String key, String value) {
        this.tester.gotoPage("/secure/admin/user/EditUserProperties.jspa?name=admin");
        this.tester.setFormElement("key", key);
        this.tester.setFormElement("value", value);
        this.tester.submit();
    }
}

