/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.ISSUE_NAVIGATOR, Category.USERS_AND_GROUPS})
public class TestUserNavigationBarWebFragment
extends FuncTestCase {
    private static final String BACK_TO_PREVIOUS_VIEW = "Back to previous view";
    private static final String ISSUE_SUMMARY = "test printable";

    @Override
    public void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestWebFragment.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    @Override
    public void tearDownTest() {
        this.navigation.login("admin", "admin");
        this.administration.restoreBlankInstance();
        super.tearDownTest();
    }

    public void testUserNavigationBarWebFragment() {
        this._testLinkVisibilityWhileLoggedIn();
        this._testLinkVisibilityWhileNotLoggedIn();
    }

    public void testPrintableViewLink() {
        this.navigation.login("admin", "admin");
        String issueKey = this.navigation.issue().createIssue("homosapien", "Bug", ISSUE_SUMMARY);
        this.navigation.issue().viewIssue(issueKey);
        this.tester.assertTextPresent("Details");
        this.tester.assertLinkPresentWithText(issueKey);
        this.tester.gotoPage("/si/jira.issueviews:issue-html/HSP-1/HSP-1.html");
        this.tester.assertLinkPresentWithText(BACK_TO_PREVIOUS_VIEW);
        this.tester.assertTextPresent("[" + issueKey + "]");
        this.tester.assertLinkPresentWithText(ISSUE_SUMMARY);
        this.tester.gotoPage("/secure/IssueNavigator.jspa?reset=true&sorter/field=issuekey&sorter/order=DESC");
        this.tester.assertTextPresent("Issue Navigator");
        this.navigation.issueNavigator().displayPrintableAllIssues();
        this.tester.assertLinkPresentWithText(BACK_TO_PREVIOUS_VIEW);
        this.tester.assertTextPresent(issueKey);
        this.tester.assertTextPresent(ISSUE_SUMMARY);
        this.tester.gotoPage("/secure/views/securitybreach.jsp");
        this.tester.assertTextPresent("Access Denied");
        this.tester.gotoPage("/secure/views/securitybreach.jsp?decorator=printable");
        this.tester.assertLinkPresentWithText(BACK_TO_PREVIOUS_VIEW);
        this.tester.assertTextPresent("Access Denied");
    }

    private void _testLinkVisibilityWhileLoggedIn() {
        this.navigation.login("admin", "admin");
        this.tester.assertLinkNotPresentWithText("Log In");
        TestUserNavigationBarWebFragment.assertTrue((boolean)this.navigation.userProfile().link().isPresent());
        TestUserNavigationBarWebFragment.assertEquals((String)"Administrator", (String)this.navigation.userProfile().userName());
        this.tester.assertLinkPresentWithText("Online Help");
        this.tester.assertLinkPresentWithText("Profile");
        this.tester.assertLinkPresentWithText("About JIRA");
        this.tester.assertLinkPresentWithText("Profile");
        this.tester.assertLinkPresentWithText("Log Out");
    }

    private void _testLinkVisibilityWhileNotLoggedIn() {
        this.navigation.logout();
        this.tester.beginAt("/secure/Dashboard.jspa");
        this.tester.assertLinkPresentWithText("Log In");
        this.tester.assertLinkNotPresentWithText("Log Out");
        TestUserNavigationBarWebFragment.assertFalse((boolean)this.navigation.userProfile().link().isPresent());
    }
}

