/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.user.DeleteUserPage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import junit.framework.AssertionFailedError;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Ignore;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestUserManagement
extends JIRAWebTest {
    public static final String JIRA_DEVELOPERS_GROUP_NAME = "jira-developers";
    public static final String JIRA_ADMINISTRATORS_GROUP_NAME = "jira-administrators";
    public static final String ISO_8859_1_JAVA_CHARS = "!@?[]~'{};&abc123\u00a3 \u00a9 \u00e5 \u00eb \u00f8 \u00e2 \u00ee \u00f4 \u00fd \u00ff \u00fc";
    public static final String ISO_8859_1_HTML_CHARS = "!@?[]~'{};&amp;abc123&pound; &copy; &aring; &euml; &oslash; &acirc; &icirc; &ocirc; &yacute; &yuml; &uuml;";
    public static final String NON_ISO_8859_1_CHARACTERS = "\uffff???";
    private static final String DUPLICATE_GROUP_NAME = "duplicate_group";
    public static final String NON_ISO_8859_1_CHAR = "\u00e4";

    public TestUserManagement(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreBlankInstance();
        this.backdoor.darkFeatures().enableForSite("jira.onboarding.feature.disabled");
    }

    public void testUserManagement() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        if (this.tester.getDialog().isLinkPresentWithText("bob")) {
            this.deleteUser("bob");
        }
        this.createUser();
        this.createValidGroup();
        this.createInvalidUsers();
        this.createInvalidGroups();
        this.addUserToGroup();
        this.loginWithNewUser();
        this.removeUserFromGroup();
        this.setUserPassword();
        this.deleteUser();
        this.loginWithInvalidUser();
    }

    @Ignore(value="JRADEV-8029 Can no longer do this in a simple func test. Need to make User Directories read-only")
    public void testUserBrowserOperationsVisibility() {
        this.toggleExternalUserManagement(false);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.assertLinkPresent("editgroups_admin");
        this.assertLinkPresent("editgroups_fred");
        this.assertLinkPresent("projectroles_link_admin");
        this.assertLinkPresent("projectroles_link_fred");
        this.assertLinkPresent("edituser_link_admin");
        this.assertLinkPresent("deleteuser_link_admin");
        this.assertLinkPresent("deleteuser_link_fred");
        this.toggleExternalUserManagement(true);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.assertLinkNotPresent("editgroups_admin");
        this.assertLinkNotPresent("editgroups_fred");
        this.assertLinkPresent("projectroles_link_admin");
        this.assertLinkPresent("projectroles_link_fred");
        this.assertLinkNotPresent("edituser_link_admin");
        this.assertLinkNotPresent("deleteuser_link_admin");
        this.assertLinkNotPresent("deleteuser_link_fred");
        this.toggleExternalUserManagement(false);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.assertLinkPresent("editgroups_admin");
        this.assertLinkPresent("editgroups_fred");
        this.assertLinkPresent("projectroles_link_admin");
        this.assertLinkPresent("projectroles_link_fred");
        this.assertLinkPresent("edituser_link_admin");
        this.assertLinkPresent("deleteuser_link_admin");
        this.assertLinkPresent("deleteuser_link_fred");
    }

    public void createInvalidUsers() {
        TestUserManagement.log("Testing User Creation Validation");
        this.addUser("", "bob", "No Username", "bob@stuff.com.com");
        this.assertTextPresent("You must specify a username.");
        this.addUser("bob", "bob", "duplicate_user", "bob@stuff.com.com");
        this.addUser("bob", "bob", "duplicate_user", "bob@stuff.com.com");
        this.assertTextPresent("A user with that username already exists.");
        this.addUser("bob", "bob", "Bob The Builder", "");
        this.assertTextPresent("You must specify an email address.");
        this.addUser("bob", "bob", "Bob The Builder", "asf.com");
        this.assertTextPresent("You must specify a valid email address.");
    }

    public void createInvalidGroups() {
        TestUserManagement.log("Testing Group Creation Validation");
        this.createGroup(DUPLICATE_GROUP_NAME);
        this.addGroup(DUPLICATE_GROUP_NAME);
        this.tester.assertTextPresent("A group or user with this name already exists.");
        this.removeGroup(DUPLICATE_GROUP_NAME);
    }

    private void addGroup(String groupName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", groupName);
        this.tester.submit();
    }

    public void createUser() {
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.tester.assertTextPresent("User: Bob The Builder");
        this.assertTextPresentBeforeText("Username:", "bob");
        this.assertTextPresentBeforeText("Email", "bob@stuff.com.com");
    }

    public void createValidGroup() {
        this.administration.usersAndGroups().addGroup("Valid Group");
        this.administration.usersAndGroups().deleteGroup("Valid Group");
    }

    public void addUserToGroup() {
        this.administration.usersAndGroups().addUserToGroup("bob", JIRA_DEVELOPERS_GROUP_NAME);
        this.administration.usersAndGroups().addUserToGroup("bob", JIRA_ADMINISTRATORS_GROUP_NAME);
    }

    public void loginWithNewUser() {
        this.navigation.logout();
        this.navigation.login("bob", "bob");
        this.assertRedirectPath(this.getEnvironmentData().getContext() + "/secure/Dashboard.jspa");
        this.navigation.logout();
        this.navigation.login("admin", "admin");
    }

    public void removeUserFromGroup() {
        this.administration.usersAndGroups().removeUserFromGroup("bob", JIRA_ADMINISTRATORS_GROUP_NAME);
    }

    public void setUserPassword() {
        String NEW_PASSWORD = "new";
        String DIFFERENT_PASSWORD = "diff";
        this.navigateToUser("bob");
        this.assertTextPresentBeforeText("User:", "Bob The Builder");
        this.tester.clickLinkWithText("Set Password");
        this.assertTextPresentBeforeText("Set Password:", "Bob The Builder");
        this.tester.setFormElement("password", "");
        this.tester.setFormElement("confirm", "");
        this.tester.submit("Update");
        this.tester.assertTextPresent("You must specify a password");
        this.tester.setFormElement("password", "");
        this.tester.setFormElement("confirm", NEW_PASSWORD);
        this.tester.submit("Update");
        this.tester.assertTextPresent("You must specify a password");
        this.tester.setFormElement("password", NEW_PASSWORD);
        this.tester.setFormElement("confirm", "");
        this.tester.submit("Update");
        this.tester.assertTextPresent("The two passwords entered do not match.");
        this.tester.setFormElement("password", NEW_PASSWORD);
        this.tester.setFormElement("confirm", DIFFERENT_PASSWORD);
        this.tester.submit("Update");
        this.tester.assertTextPresent("The two passwords entered do not match.");
        this.tester.setFormElement("password", NEW_PASSWORD);
        this.tester.setFormElement("confirm", NEW_PASSWORD);
        this.tester.submit("Update");
        this.assertTextPresentBeforeText("Password for user bob has successfully been set", "Bob The Builder");
        this.navigation.logout();
        this.navigation.loginAttempt("bob", "bob");
        this.tester.assertTextPresent("Sorry, your username and password are incorrect - please try again.");
        this.navigation.login("bob", NEW_PASSWORD);
        TestUserManagement.assertEquals((String)"Bob The Builder", (String)this.navigation.userProfile().userName());
        this.navigation.login("admin", "admin");
    }

    public void deleteUser() {
        this.deleteUser("bob");
        this.tester.assertTextPresent("UserBrowser");
        this.tester.assertTextPresent("Displaying users");
        this.administration.usersAndGroups().addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
    }

    public void testDeleteUserProjectLead() {
        this.administration.restoreData("TestUserManagement.xml");
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("detkin"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("detkin")));
        this.text.assertTextPresent(deleteUserPage.getProjectLink(), "Another Project");
        this.text.assertTextPresent(deleteUserPage.getProjectLink(), "Project 3");
    }

    public void testDeleteUserComponentLead() {
        this.administration.restoreData("TestUserManagementComponentLead.xml");
        this.navigateToUser("detkin");
        this.tester.clickLink("deleteuser_link");
        int NUMBER_OF_COMPONENTS = 6;
        int count = 0;
        for (int i = 1; i <= 6; ++i) {
            try {
                this.tester.assertLinkPresentWithText("comp " + i);
                ++count;
                continue;
            }
            catch (AssertionFailedError assertionFailedError) {
                // empty catch block
            }
        }
        TestUserManagement.assertTrue((count == 6 ? 1 : 0) != 0);
        this.tester.assertSubmitButtonPresent("Delete");
    }

    public void loginWithInvalidUser() {
        this.navigation.logout();
        this.navigation.loginAttempt("bob", null);
        this.tester.assertTextPresent("Sorry, your username and password are incorrect - please try again.");
    }
}

