/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.admin.GeneralConfiguration;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.joda.time.DateTimeZone;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestUserHover
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestUserHover.xml");
    }

    public void testUserHover() {
        this.gotoUserHover("unknownuser");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "User does not exist: unknownuser");
        this.tester.assertLinkNotPresentWithText("Current Issues");
        this.tester.assertLinkNotPresentWithText("Profile");
        this.gotoUserHover("admin");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Administrator");
        this.tester.assertLinkPresentWithText("admin@example.com");
        this.tester.assertLinkPresentWithText("Current Issues");
        this.tester.assertLinkPresentWithText("Profile");
        this.tester.assertLinkNotPresent("update_avatar_link");
        this.gotoUserHover("brad");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Brad Baker");
        this.tester.assertLinkPresentWithText("brad@example.com");
        this.tester.assertLinkPresentWithText("Current Issues");
        this.tester.assertLinkPresentWithText("Profile");
        this.navigation.logout();
        this.gotoUserHover("brad");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Brad Baker");
        this.tester.assertLinkNotPresentWithText("brad@example.com");
        this.tester.assertLinkNotPresentWithText("Current Issues");
        this.tester.assertLinkNotPresentWithText("Profile");
        this.navigation.login("admin", "admin");
        this.administration.generalConfiguration().setUserEmailVisibility(GeneralConfiguration.EmailVisibility.MASKED);
        this.gotoUserHover("brad");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Brad Baker");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "brad at example dot com");
        this.tester.assertLinkNotPresentWithText("brad@example.com");
        this.tester.assertLinkPresentWithText("Current Issues");
        this.tester.assertLinkPresentWithText("Profile");
        this.backdoor.usersAndGroups().addUser("bob");
        this.navigation.logout();
        this.navigation.login("bob");
        this.gotoUserHover("bob");
        this.tester.assertLinkPresent("update_avatar_link");
        this.navigation.logout();
        this.gotoUserHover("admin");
        this.text.assertTextPresent(new WebPageLocator(this.tester), "Administrator");
        this.tester.assertLinkNotPresentWithText("admin@example.com");
        this.tester.assertTextNotPresent("admin@example.com");
        this.tester.assertLinkNotPresentWithText("Current Issues");
        this.tester.assertLinkNotPresentWithText("Profile");
    }

    public void testLocalTimeShouldBeDisplayedInUserHover() throws Exception {
        this.gotoUserHover("admin");
        String hourOfDayAdmin = this.hourOfDay();
        Assert.assertThat((String)"time of day info is present", (Object)this.locator.css(".time-zone-info").getNode(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)("hour icon shows correct hour=" + hourOfDayAdmin), (Object)this.locator.css(".user-time-icon.hour-of-day-" + hourOfDayAdmin).getNode(), (Matcher)CoreMatchers.notNullValue());
        this.gotoUserHover("unknownuser");
        Assert.assertThat((String)"time of day info is present", (Object)this.locator.css(".time-zone-info").getNode(), (Matcher)CoreMatchers.nullValue());
        this.gotoUserHover("brad");
        String hourOfDayBrad = this.hourOfDay("Pacific/Palau");
        Assert.assertThat((String)"time of info is present", (Object)this.locator.css(".time-zone-info").getNode(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((String)("hour icon shows correct hour=" + hourOfDayBrad), (Object)this.locator.css(".user-time-icon.hour-of-day-" + hourOfDayBrad).getNode(), (Matcher)CoreMatchers.notNullValue());
        this.navigation.logout();
        this.gotoUserHover("brad");
        Assert.assertThat((String)"time of day info is present", (Object)this.locator.css(".time-zone-info").getNode(), (Matcher)CoreMatchers.nullValue());
    }

    protected void gotoUserHover(String username) {
        this.navigation.gotoPage("/secure/ViewUserHover!default.jspa?decorator=none&username=" + username);
    }

    protected String hourOfDay() {
        return this.hourOfDay(DateTimeZone.getDefault().getID());
    }

    protected String hourOfDay(String timeZoneID) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH");
        dateFormat.setTimeZone(TimeZone.getTimeZone(timeZoneID));
        return dateFormat.format(new Date());
    }
}

