/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.UserProfile;
import com.atlassian.jira.functest.framework.parser.issue.ViewIssueDetails;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestUserHistory
extends FuncTestCase {
    private static final String INTERNAL_ADMIN_FULL = "Administrator in the Shadows";
    private static final String INTERNAL_ADMIN_NAME = "admin";

    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestUserHistoryErrors.xml");
    }

    public void testCreateIssue() throws Exception {
        String summary = "Second Issue";
        this.createIssue(summary, INTERNAL_ADMIN_NAME);
        this.assertIssue(summary, INTERNAL_ADMIN_FULL);
    }

    public void testProfilePage() throws Exception {
        UserProfile userProfile = this.navigation.userProfile();
        userProfile.gotoCurrentUserProfile();
        TestUserHistory.assertEquals((String)INTERNAL_ADMIN_FULL, (String)userProfile.userName());
    }

    private void assertIssue(String summary, String fullUserName) {
        ViewIssueDetails viewIssueDetails = this.parse.issue().parseViewIssuePage();
        TestUserHistory.assertEquals((String)summary, (String)viewIssueDetails.getSummary());
        TestUserHistory.assertEquals((String)fullUserName, (String)viewIssueDetails.getAssignee());
    }

    private String createIssue(String summary, String userName) {
        this.tester.clickLink("create_link");
        this.tester.setWorkingForm("issue-create");
        this.tester.submit();
        this.tester.setFormElement("summary", summary);
        this.tester.setFormElement("assignee", userName);
        this.tester.submit();
        return this.parse.issue().parseViewIssuePage().getKey();
    }
}

