/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.webtests.JIRAWebTest;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestUserGroupPicker
extends JIRAWebTest {
    private static final String USER_FIELD_NAME = "User field";
    private static final String SUMMARY_FRED = "Issue with user picker fred";
    private static final String SUMMARY_BOTH = "Issue with user picker admin, fred";
    private static final String SUMMARY_ADMIN = "Issue with user picker admin";
    private static final String THREE_ISSUES = "all 3 issue(s)";
    private static final String TWO_ISSUES = "all 2 issue(s)";
    private static final String USER_FIELD_ID = "customfield_10000";

    public TestUserGroupPicker(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.administration.restoreData("blankprojects.xml");
        this.administration.addGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
    }

    @Override
    public void tearDown() {
        this.administration.removeGlobalPermission(GlobalPermissionKey.BULK_CHANGE, "jira-users");
        super.tearDown();
    }

    public void testUserGroupPicker() throws Exception {
        this._testCustomFieldSetup();
        this._testCreateIssueWithField();
    }

    private void _testCustomFieldSetup() {
        TestUserGroupPicker.logSection("Adding Mutli user field and Group searcher");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.clickLink("add_custom_fields");
        this.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker");
        this.submit("nextBtn");
        this.setFormElement("fieldName", USER_FIELD_NAME);
        this.selectOption("searcher", "User Picker & Group Searcher");
        this.submit("nextBtn");
        this.checkCheckbox("associatedScreens", "1");
        this.submit("Update");
    }

    private void _testCreateIssueWithField() {
        TestUserGroupPicker.logSection("Creating issues with Mutli user field and Group searcher");
        this._testCreateIssueWithUser("admin", "Administrator");
        this._testCreateIssueWithUser("fred", "Fred Normal");
        this._createIssueWithUser("admin, fred");
        this.assertTextPresentBeforeText(USER_FIELD_NAME, "Administrator");
        this.assertTextPresentBeforeText(USER_FIELD_NAME, "Fred Normal");
        this.assertTextPresentBeforeText("Administrator", "Fred Normal");
    }

    private void _testCreateIssueWithUser(String username, String fullName) {
        this._createIssueWithUser(username);
        this.assertTextPresentBeforeText(USER_FIELD_NAME, fullName);
        this.assertTextPresent("Issue with user picker " + username);
    }

    private void _createIssueWithUser(String username) {
        this.getNavigation().issue().goToCreateIssueForm("homosapien", "Bug");
        this.setFormElement("summary", "Issue with user picker " + username);
        this.assertTextPresent(USER_FIELD_NAME);
        this.setFormElement(USER_FIELD_ID, username);
        this.submit("Create");
    }
}

