/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.TimeTracking;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.locator.XPathLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.projects.pageobjects.backdoor.SidebarDarkFeatureControl;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.meterware.httpunit.WebLink;
import java.util.List;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestUserFormat
extends FuncTestCase {
    private SidebarDarkFeatureControl sidebarDarkFeatureControl;
    private boolean sidebarWasEnabled;

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.sidebarDarkFeatureControl = new SidebarDarkFeatureControl((JIRAEnvironmentData)this.getEnvironmentData());
        this.sidebarWasEnabled = this.sidebarDarkFeatureControl.isEnabledForSite();
        if (this.sidebarWasEnabled) {
            this.sidebarDarkFeatureControl.disableSidebarForSite();
        }
    }

    @Override
    protected void tearDownTest() {
        if (this.sidebarWasEnabled) {
            this.sidebarDarkFeatureControl.enableSidebarForSite();
        }
    }

    public void testAnonymous() {
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "My first test comment");
        this.tester.submit();
        this.assertions.assertProfileLinkPresent("commentauthor_10000_verbose", "Administrator");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.BROWSE_PROJECTS.permissionKey(), "");
        this.administration.permissionSchemes().defaultScheme().grantPermissionToGroup(ProjectPermissions.ADD_COMMENTS.permissionKey(), "");
        this.navigation.logout();
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "My second anoymous test comment");
        this.tester.submit();
        this.tester.assertLinkNotPresent("Anonymous");
        this.text.assertTextSequence(new WebPageLocator(this.tester), "Anonymous", "added a comment");
    }

    public void testCommentPanel() {
        this.tester.gotoPage("/secure/admin/AddPermission!default.jspa?permissions=" + ProjectPermissions.EDIT_ALL_COMMENTS.permissionKey() + "&schemeId=0");
        this.tester.checkCheckbox("type", "group");
        this.tester.submit(" Add ");
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "My first test comment");
        this.tester.submit();
        this.tester.clickLink("edit_comment_10000");
        this.tester.setWorkingForm("comment-edit");
        this.assertions.assertProfileLinkPresent("comment_summary_admin", "Administrator");
        this.tester.setFormElement("comment", "My first test comment edited...");
        try {
            Thread.sleep(1001L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.tester.submit("Save");
        this.tester.clickLink("edit_comment_10000");
        this.tester.setWorkingForm("comment-edit");
        this.assertions.assertProfileLinkPresent("comment_summary_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("comment_summary_updated_admin", "Administrator");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("delete_comment_10000");
        this.assertions.assertProfileLinkPresent("comment_summary_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("comment_summary_updated_admin", "Administrator");
    }

    public void testViewProjects() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.assertions.assertProfileLinkPresent("view_HSP_projects_admin", "Administrator");
    }

    public void testBrowseComponent() {
        this.administration.project().editComponent("HSP", "New Component 1", "New Component 1", null, "fred");
        this.tester.gotoPage("/browse/HSP?selectedTab=com.atlassian.jira.jira-projects-plugin:components-panel");
        this.assertions.assertProfileLinkPresent("component_lead_fred", "Fred Normal");
        this.tester.gotoPage("/browse/HSP/component/10000");
        this.assertions.assertProfileLinkPresent("component_summary_fred", "Fred Normal");
    }

    public void testBrowseProject() {
        this.tester.gotoPage("/browse/HSP");
        this.assertions.assertProfileLinkPresent("project_summary_admin", "Administrator");
    }

    public void testViewVoters() {
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.logout();
        this.navigation.login("fred");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("toggle-vote-issue");
        this.navigation.logout();
        this.navigation.login("admin");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("view-voters");
        this.assertions.assertProfileLinkPresent("voter_link_fred", "Fred Normal");
    }

    public void testFullProfileIsSafeFromXSS() {
        this.tester.gotoPage("/secure/EditProfile!default.jspa?username=admin");
        this.tester.setFormElement("fullName", "admin \"<script>alert('owned')</script>\"");
        this.tester.setFormElement("email", "\"<script>alert('owned')</script>\"@localhost");
        this.tester.setFormElement("password", "admin");
        this.tester.submit();
        this.tester.gotoPage("/secure/ViewProfile.jspa");
        TestUserFormat.assertTrue((this.tester.getDialog().getResponseText().indexOf("User Profile: admin &quot;&lt;script&gt;alert(&#39;owned&#39;)&lt;/script&gt;&quot;") != -1 ? 1 : 0) != 0);
        TestUserFormat.assertTrue((this.tester.getDialog().getResponseText().indexOf("User Profile: admin \"<script>alert(&#39;owned&#39;)</script>\"") == -1 ? 1 : 0) != 0);
        TestUserFormat.assertTrue((this.tester.getDialog().getResponseText().indexOf("mailto:&quot;&lt;script&gt;alert(&#39;owned&#39;)&lt;/script&gt;&quot;") != -1 ? 1 : 0) != 0);
        TestUserFormat.assertTrue((this.tester.getDialog().getResponseText().indexOf("mailto:\"<script>alert('owned')</script>\"") == -1 ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIssueSummary() {
        this.tester.gotoPage("/secure/admin/AddPermission!default.jspa?permissions=" + ProjectPermissions.ASSIGNABLE_USER.permissionKey() + "&schemeId=0");
        this.tester.checkCheckbox("type", "group");
        this.tester.submit(" Add ");
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        try {
            this.backdoor.darkFeatures().enableForSite("no.frother.assignee.field");
            this.tester.clickLink("assign-issue");
            this.tester.selectOption("assignee", "Fred Normal");
            this.tester.submit("Assign");
        }
        finally {
            this.backdoor.darkFeatures().disableForSite("no.frother.assignee.field");
        }
        this.assertions.assertNodeByIdHasText("issue_summary_assignee_fred", "Fred Normal");
        this.assertions.assertNodeByIdHasText("issue_summary_reporter_admin", "Administrator");
    }

    public void testColumnView() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertions.assertProfileLinkPresent("assignee_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("reporter_admin", "Administrator");
    }

    public void testColumnViewUnAssigned() throws SAXException {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GENERAL_CONFIGURATION);
        this.tester.clickLink("edit-app-properties");
        this.tester.checkCheckbox("allowUnassigned", "true");
        this.tester.submit("Update");
        this.navigation.issue().goToCreateIssueForm(null, null);
        this.tester.setFormElement("summary", "Unassigned bug");
        this.tester.selectOption("assignee", "Unassigned");
        this.tester.submit("Create");
        this.navigation.issueNavigator().displayAllIssues();
        WebLink link = this.tester.getDialog().getResponse().getLinkWithID("assignee_admin");
        TestUserFormat.assertNull((Object)link);
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", 1, 3), "Unassigned");
        this.assertions.assertProfileLinkPresent("reporter_admin", "Administrator");
    }

    public void testIssueWatchers() {
        this.navigation.userProfile().changeAutowatch(false);
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("toggle-watch-issue");
        this.tester.clickLink("manage-watchers");
        this.assertions.assertProfileLinkPresent("watcher_link_admin", "Administrator");
    }

    public void testCustomFields() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:userpicker");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "Single User");
        this.tester.submit("nextBtn");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit("Update");
        this.tester.clickLink("add_custom_fields");
        this.tester.checkCheckbox("fieldType", "com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker");
        this.tester.submit("nextBtn");
        this.tester.setFormElement("fieldName", "Multi User");
        this.tester.submit("nextBtn");
        this.tester.checkCheckbox("associatedScreens", "1");
        this.tester.submit("Update");
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("customfield_10000", "fred");
        this.tester.setFormElement("customfield_10001", "admin, fred");
        this.tester.submit("Update");
        this.assertions.assertNodeByIdHasText("user_cf_fred", "Fred Normal");
        this.assertions.assertNodeByIdHasText("multiuser_cf_fred", "Fred Normal");
        this.assertions.assertNodeByIdHasText("multiuser_cf_admin", "Administrator");
    }

    public void testActionHeaders() {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("footer-comment-button");
        this.tester.setFormElement("comment", "My first test comment");
        this.tester.submit();
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", "1h");
        this.tester.clickButton("log-work-submit");
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("summary", "First test bug really");
        this.tester.submit("Update");
        this.tester.gotoPage("/browse/HSP-1?page=com.atlassian.jira.plugin.system.issuetabpanels%3Aall-tabpanel");
        this.assertions.assertProfileLinkPresent("commentauthor_10000_verbose", "Administrator");
        this.assertions.assertProfileLinkPresent("changehistoryauthor_10000", "Administrator");
        this.assertions.assertProfileLinkPresent("changehistoryauthor_10001", "Administrator");
        this.assertions.assertProfileLinkPresent("worklogauthor_10000", "Administrator");
    }

    public void testDeveloperWorkloadReport() {
        this.administration.timeTracking().enable(TimeTracking.Mode.LEGACY);
        String issueKey = this.navigation.issue().createIssue("homosapien", null, "First test bug");
        this.navigation.issue().viewIssue(issueKey);
        this.tester.clickLink("log-work");
        this.tester.setFormElement("timeLogged", "1h");
        this.tester.clickButton("log-work-submit");
        this.navigation.runReport(10000L, "com.atlassian.jira.plugin.system.reports:developer-workload");
        this.tester.setFormElement("developer", "admin");
        this.tester.submit("Next");
        this.assertions.assertProfileLinkPresent("dev_wl_report_admin", "Administrator");
    }

    public void testDifferentUsersInIterator() {
        this.administration.restoreData("TestFormatUserDifferentUsersInIterator.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_PROJECTS);
        this.assertions.assertProfileLinkPresent("view_HSP_projects_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("view_MKY_projects_fred", "Fred Normal");
        this.tester.gotoPage("/secure/ViewVoters!default.jspa?id=10001");
        this.assertions.assertProfileLinkPresent("voter_link_admin", "Administrator");
        this.assertions.assertProfileLinkPresent("voter_link_fred", "Fred Normal");
    }

    private void assertFullProfilePresent(String username, String fullName, String email, List groups) {
        IdLocator tableLocator = new IdLocator(this.tester, "full_profile");
        this.text.assertTextSequence(tableLocator, new String[]{"Username", username, "Full Name", fullName, "Email", email, "Groups"});
        for (Object group : groups) {
            String groupName = (String)group;
            this.text.assertTextPresent(new XPathLocator(this.tester, "//ul[@id='full_profile']/li[4]"), groupName);
        }
        this.text.assertTextSequence(new IdLocator(this.tester, "full_profile_ops"), new String[]{"View OAuth Access Tokens"});
    }
}

