/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.CssLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestUserDefaults
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testIssuesPerPageValidation() throws Exception {
        this._testIssuesPerPageValidation("0", false);
        this._testIssuesPerPageValidation("-100", false);
        this._testIssuesPerPageValidation("1001", false);
        this._testIssuesPerPageValidation("1", true);
        this._testIssuesPerPageValidation("1000", true);
        this._testIssuesPerPageValidation("500", true);
    }

    private void _testIssuesPerPageValidation(String setting, boolean valid) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DEFAULTS);
        this.tester.clickLink("user-defaults-edit");
        this.tester.setWorkingForm("edit_user_defaults");
        this.tester.setFormElement("numIssues", setting);
        this.tester.submit("Update");
        if (valid) {
            this.assertions.getTextAssertions().assertTextSequence(new CssLocator(this.tester, "#view_user_defaults"), new String[]{"Number of Issues displayed per Issue Navigator page", setting});
        } else {
            this.assertions.assertNodeHasText(new CssLocator(this.tester, ".error"), "Issues per page must be a number between 1 and 1000");
        }
    }
}

