/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestShareUserDefault
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestShareUserDefaults.xml");
    }

    @Override
    public void tearDownTest() {
        this.administration.restoreBlankInstance();
    }

    public void testDefaults() {
        this.navigation.login("admin", "admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DEFAULTS);
        TableCellLocator locator = new TableCellLocator(this.tester, "view_user_defaults", 3, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        locator = new TableCellLocator(this.tester, "view_user_defaults", 3, 1);
        this.text.assertTextPresent(locator, "Private");
        this.tester.gotoPage("secure/ViewProfile.jspa");
        this.tester.clickLink("edit_prefs_lnk");
        this.tester.assertRadioOptionPresent("shareDefault", "true");
        this.tester.assertRadioOptionPresent("shareDefault", "false");
        this.tester.assertRadioOptionSelected("shareDefault", "true");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DEFAULTS);
        this.tester.clickLinkWithText("Edit default values");
        this.tester.setFormElement("sharePublic", "false");
        this.tester.submit("Update");
        locator = new TableCellLocator(this.tester, "view_user_defaults", 3, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        locator = new TableCellLocator(this.tester, "view_user_defaults", 3, 1);
        this.text.assertTextPresent(locator, "Public");
        this.tester.gotoPage("secure/ViewProfile.jspa");
        this.tester.clickLink("edit_prefs_lnk");
        this.tester.assertRadioOptionPresent("shareDefault", "true");
        this.tester.assertRadioOptionPresent("shareDefault", "false");
        this.tester.assertRadioOptionSelected("shareDefault", "false");
        this.tester.checkCheckbox("shareDefault", "true");
        this.tester.submit();
        this.tester.gotoPage("secure/ViewProfile.jspa");
        this.tester.clickLink("edit_prefs_lnk");
        this.tester.assertRadioOptionPresent("shareDefault", "true");
        this.tester.assertRadioOptionPresent("shareDefault", "false");
        this.tester.assertRadioOptionSelected("shareDefault", "true");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DEFAULTS);
        locator = new TableCellLocator(this.tester, "view_user_defaults", 3, 0);
        this.text.assertTextPresent(locator, "Default sharing for filters and dashboards");
        locator = new TableCellLocator(this.tester, "view_user_defaults", 3, 1);
        this.text.assertTextPresent(locator, "Public");
    }
}

