/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableCellLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestNonExistentUsers
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("TestNonExistentUsers.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
    }

    public void testNullReporterAndAssignee() {
        this.administration.restoreData("TestNullAssigneeAndReporter.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.assertViewIssueAssigneeAndReporter("AA-1", "Unassigned", "Anonymous");
        this.assertViewIssueAssigneeAndReporter("AA-2", "Unassigned", "admin");
        this.assertViewIssueAssigneeAndReporter("AA-3", "admin", "Anonymous");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertNavigatorAssigneeAndReporter(1, "AA-3", "admin", "Anonymous");
        this.assertNavigatorAssigneeAndReporter(2, "AA-2", "Unassigned", "admin");
        this.assertNavigatorAssigneeAndReporter(3, "AA-1", "Unassigned", "Anonymous");
    }

    private void assertNavigatorAssigneeAndReporter(int row, String issueKey, String assigneeName, String reporterName) {
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", row, 1), issueKey);
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", row, 3), assigneeName);
        this.text.assertTextPresent(new TableCellLocator(this.tester, "issuetable", row, 4), reporterName);
    }

    private void assertViewIssueAssigneeAndReporter(String issueKey, String assigneeName, String reporterName) {
        this.navigation.issue().viewIssue(issueKey);
        this.text.assertTextSequence(new IdLocator(this.tester, "assignee-val"), assigneeName, new String[0]);
        this.text.assertTextSequence(new IdLocator(this.tester, "reporter-val"), reporterName, new String[0]);
    }

    public void testUserWithNoFullName() {
        this.administration.restoreData("TestNonExistentUsersNoFullname.xml");
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.issueNavigator().displayAllIssues();
        this.assertions.assertProfileLinkPresent("assignee_admin", "admin");
        this.assertions.assertProfileLinkPresent("reporter_admin", "admin");
        this.navigation.issue().viewIssue("HSP-1");
        this.assertions.assertProfileLinkPresent("commentauthor_10000_verbose", "admin");
    }
}

