/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.WebTestCaseWrapper;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS, Category.USERS_AND_GROUPS})
public class TestGroupSelectorPermissions
extends FuncTestCase {
    @Override
    protected void setUpTest() {
        this.administration.restoreData("GroupSelectorPermissions.xml");
        this.backdoor.darkFeatures().enableForSite("ka.NO_GLOBAL_SHORTCUT_LINKS");
        this.administration.attachments().enable();
    }

    public void testWorkflowPermissions() {
        WebTestCaseWrapper.logSection("Testing group permission selector");
        this.log("Testing that 'GroupRadio' selection (helpdesk) can comment, can't attach");
        this.navigation.login("helpdesk", "helpdesk");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.assertLinkPresent("comment-issue");
        this.tester.assertLinkPresent("footer-comment-button");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.assertLinkNotPresent("delete-issue");
        this.tester.assertLinkNotPresent("move-issue");
        this.log("Check that webadmin users cannot do anything");
        this.navigation.login("webadmin", "webadmin");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.assertLinkNotPresent("comment-issue");
        this.tester.assertLinkNotPresent("footer-comment-button");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.assertLinkNotPresent("delete-issue");
        this.tester.assertLinkNotPresent("move-issue");
        this.log("Check that unixadmin users cannot do anything");
        this.navigation.login("unixadmin", "unixadmin");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.assertLinkNotPresent("comment-issue");
        this.tester.assertLinkNotPresent("footer-comment-button");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.assertLinkNotPresent("delete-issue");
        this.tester.assertLinkNotPresent("move-issue");
        this.log("Testing that regular users can't comment, can't attach");
        this.navigation.login("test", "test");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.assertLinkNotPresent("comment-issue");
        this.tester.assertLinkNotPresent("footer-comment-button");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.assertLinkNotPresent("delete-issue");
        this.tester.assertLinkNotPresent("move-issue");
        this.navigation.login("dba", "dba");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.assertLinkNotPresent("comment-issue");
        this.tester.assertLinkNotPresent("footer-comment-button");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.assertLinkNotPresent("delete-issue");
        this.tester.assertLinkNotPresent("move-issue");
        this.log("Editing fields: setting GroupRadio (comment perm) to WebAdmin, and 'Assigned Groups' (attach perm) to helpdesk");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.clickLink("edit-issue");
        this.tester.assertOptionValuesEqual("customfield_10010", new String[]{"-1", "10000", "10001", "10002", "10003"});
        this.tester.assertOptionValuesEqual("customfield_10030", new String[]{"-1", "10020", "10021", "10022", "10023"});
        this.tester.assertOptionValuesEqual("customfield_10040", new String[]{"10030", "10031", "10032", "10033"});
        this.tester.assertOptionValuesEqual("customfield_10041", new String[]{"-1", "10034", "10035", "10036", "10037"});
        this.tester.selectOption("customfield_10010", "help-desk-group");
        this.tester.checkCheckbox("customfield_10030", "10023");
        this.tester.setFormElement("customfield_10040", "10030");
        this.tester.selectOption("customfield_10041", "unix-admin-group");
        this.tester.submit();
        String response = this.tester.getDialog().getResponseText();
        this.assertions.text().assertTextSequence(response, "Assigned Groups:", "help-desk-group");
        this.assertions.text().assertTextSequence(response, "GroupRadio:", "webadmin-group");
        this.assertions.text().assertTextSequence(response, "Multi Checkboxes:", "dba-user-group");
        this.assertions.text().assertTextSequence(response, "Select List:", "unix-admin-group");
        this.log("Testing that 'GroupRadio' selection (now webadmin) can comment, can't attach");
        this.navigation.login("webadmin", "webadmin");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.assertLinkPresent("comment-issue");
        this.tester.assertLinkPresent("footer-comment-button");
        this.tester.assertLinkNotPresent("delete-issue");
        this.tester.assertLinkNotPresent("move-issue");
        this.log("Testing that helpdesk can no longer comment, but can attach");
        this.navigation.login("helpdesk", "helpdesk");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.assertLinkPresent("attach-file");
        this.tester.assertLinkNotPresent("comment-issue");
        this.tester.assertLinkNotPresent("footer-comment-button");
        this.tester.assertLinkNotPresent("delete-issue");
        this.tester.assertLinkNotPresent("move-issue");
        this.log("Check that DBA can delete issues");
        this.navigation.login("dba", "dba");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.assertLinkNotPresent("comment-issue");
        this.tester.assertLinkNotPresent("footer-comment-button");
        this.tester.assertLinkNotPresent("delete-issue");
        this.tester.assertLinkPresent("move-issue");
        this.log("Check that Unix admin can move issues");
        this.navigation.login("unixadmin", "unixadmin");
        this.navigation.issue().gotoIssue("NP-1");
        this.tester.assertLinkNotPresent("attach-file");
        this.tester.assertLinkNotPresent("comment-issue");
        this.tester.assertLinkNotPresent("footer-comment-button");
        this.tester.assertLinkPresent("delete-issue");
        this.tester.assertLinkNotPresent("move-issue");
    }
}

