/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.JIRAWebTest;
import com.meterware.httpunit.WebTable;
import org.junit.Ignore;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestExternalUserManagement
extends JIRAWebTest {
    private static final String USERNAME_JOHN = "john";
    private static final String NAME_JOHN_WAYNE = "John Wayne";
    private static final int GROUP_COL = 3;

    public TestExternalUserManagement(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        super.setUp();
        this.restoreBlankInstance();
    }

    @Ignore(value="JRADEV-8029 Can no longer do this in a simple func test. Need to make User Directories read-only")
    public void testAddUser() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.assertLinkPresent("create_user");
        this.clickLink("create_user");
        this.setFormElement("username", USERNAME_JOHN);
        this.setFormElement("password", "some_pass");
        this.setFormElement("confirm", "some_pass");
        this.setFormElement("fullname", NAME_JOHN_WAYNE);
        this.setFormElement("email", "john@atlassian.com");
        this.submit("Create");
        this.assertTextPresent("User: John Wayne");
        this.toggleExternalUserManagement(true);
        this.assertLinkNotPresent("create_user");
        this.gotoPage("/secure/admin/user/AddUser!default.jspa");
        this.submit("Create");
        this.assertTextPresent("Cannot add user, as external user management is enabled, please contact your JIRA administrators.");
    }

    @Ignore(value="JRADEV-8029 Can no longer do this in a simple func test. Need to make User Directories read-only")
    public void testEditUserGroups() throws SAXException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        WebTable userTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 1, 3, "jira-developers"));
        this.assertTextPresent("jira-developers");
        this.assertLinkPresentWithText("Groups");
        this.clickLink("editgroups_admin");
        this.selectMultiOptionByValue("groupsToLeave", "jira-developers");
        this.submit("leave");
        userTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellDoesNotHaveText(userTable, 1, 3, "jira-developers"));
        this.toggleExternalUserManagement(true);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        userTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 1, 3, "jira-users"));
        this.assertLinkNotPresent("editgroups_admin");
        this.gotoPage("/secure/admin/user/EditUserGroups!default.jspa?returnUrl=UserBrowser.jspa&name=admin");
        this.selectMultiOptionByValue("groupsToLeave", "jira-users");
        this.submit("leave");
        this.assertTextPresent("Cannot edit group memberships, as external user management is enabled, please contact your JIRA administrators.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        userTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 1, 3, "jira-users"));
    }

    @Ignore(value="JRADEV-8029 Can no longer do this in a simple func test. Need to make User Directories read-onlyJRADEV-18305 Needs to be converted to WebDriver because the Multi User Picker can only be interacted with via JS")
    public void testBulkEditUserGroups() throws SAXException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        WebTable userTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 1, 1, "1"));
        this.clickLink("edit_members_of_jira-administrators");
        this.setFormElement("usersToAssignStr", "fred");
        this.submit("assign");
        this.clickLink("group_browser");
        userTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 1, 1, "2"));
        this.toggleExternalUserManagement(true);
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        userTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 2, 1, "1"));
        this.assertLinkNotPresent("edit_members_of_jira-developers");
        this.gotoPage("/secure/admin/user/BulkEditUserGroups!default.jspa?selectedGroupsStr=jira-developers");
        this.setFormElement("usersToAssignStr", "fred");
        this.submit("assign");
        this.assertTextPresent("Cannot edit group memberships, as external user management is enabled, please contact your JIRA administrators.");
        this.gotoPage("/secure/admin/user/BulkEditUserGroups!default.jspa?selectedGroupsStr=jira-developers");
        this.selectOption("usersToUnassign", "admin");
        this.submit("unassign");
        this.assertTextPresent("Cannot edit group memberships, as external user management is enabled, please contact your JIRA administrators.");
        this.clickLink("group_browser");
        userTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertTrue((boolean)this.tableCellHasText(userTable, 2, 1, "1"));
    }

    @Ignore(value="JRADEV-8029 Can no longer do this in a simple func test. Need to make User Directories read-only")
    public void testGroupEditPage() throws SAXException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.assertTextPresent("You can also add and remove groups from here.");
        this.assertElementPresent("add-group");
        this.assertLinkPresent("bulk_edit_groups");
        WebTable groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)4, (int)groupBrowserTable.getColumnCount());
        TestExternalUserManagement.assertEquals((int)4, (int)groupBrowserTable.getRowCount());
        this.setFormElement("addName", "test-new-group");
        this.submit("add_group");
        this.assertTextPresent("test-new-group");
        groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)5, (int)groupBrowserTable.getRowCount());
        this.toggleExternalUserManagement(true);
        this.clickLink("group_browser");
        this.assertTextNotPresent("You can also add and remove groups from here.");
        this.assertElementNotPresent("add-group");
        this.assertLinkNotPresent("bulk_edit_groups");
        this.gotoPage(this.page.addXsrfToken("/secure/admin/user/GroupBrowser!add.jspa?addName=another-test-group"));
        this.assertTextPresent("Cannot add groups, as external user management is enabled, please contact your JIRA administrators.");
        groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)groupBrowserTable.getColumnCount());
        TestExternalUserManagement.assertEquals((int)5, (int)groupBrowserTable.getRowCount());
    }

    @Ignore(value="JRADEV-8029 Can no longer do this in a simple func test. Need to make User Directories read-only")
    public void testDeleteGroup() throws SAXException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        WebTable groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)4, (int)groupBrowserTable.getRowCount());
        this.assertLinkPresent("del_jira-users");
        this.clickLink("del_jira-users");
        this.submit("Delete");
        groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)groupBrowserTable.getRowCount());
        this.toggleExternalUserManagement(true);
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)groupBrowserTable.getRowCount());
        this.assertLinkNotPresent("del_jira-developers");
        this.gotoPage("/secure/admin/user/DeleteGroup!default.jspa?name=jira-developers");
        this.submit("Delete");
        this.assertTextPresent("Cannot delete group, as external user management is enabled, please contact your JIRA administrators.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        groupBrowserTable = this.getDialog().getResponse().getTableWithID("group_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)groupBrowserTable.getRowCount());
    }

    @Ignore(value="JRADEV-8029 Can no longer do this in a simple func test. Need to make User Directories read-only")
    public void testDeleteUser() throws SAXException {
        this.gotoAdmin();
        this.addUser("bob", "bob", "Bob The Builder", "bob@stuff.com.com");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        WebTable userBrowserTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertEquals((int)4, (int)userBrowserTable.getRowCount());
        this.assertLinkPresent("deleteuser_link_fred");
        this.clickLink("deleteuser_link_fred");
        this.submit("Delete");
        userBrowserTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)userBrowserTable.getRowCount());
        this.toggleExternalUserManagement(true);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.assertLinkNotPresent("deleteuser_link_bob");
        this.gotoPage("/secure/admin/user/DeleteUser!default.jspa?returnUrl=UserBrowser.jspa&name=bob");
        this.submit("Delete");
        this.assertTextPresent("Cannot delete user, as external user management is enabled, please contact your JIRA administrators.");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        userBrowserTable = this.getDialog().getResponse().getTableWithID("user_browser_table");
        TestExternalUserManagement.assertEquals((int)3, (int)userBrowserTable.getRowCount());
    }

    public void testSystemInfo() {
        this.gotoPage("/secure/admin/jira/ViewSystemInfo.jspa");
        this.assertTextPresent("External user management");
        this.assertTextPresentAfterText("OFF", "External user management");
        this.assertTextNotPresent("External user management is enabled. Showing records from local database tables only.");
        this.toggleExternalUserManagement(true);
        this.gotoPage("/secure/admin/jira/ViewSystemInfo.jspa");
        this.assertTextPresent("External user management");
        this.assertTextPresentAfterText("ON", "External user management");
        this.assertTextPresent("External user management is enabled. Showing records from local database tables only.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSignupLinkOnLoginPage() {
        try {
            this.toggleExternalUserManagement(true);
            this.logout();
            this.gotoPage("login.jsp");
            this.assertLinkNotPresent("signup");
        }
        finally {
            this.login("admin", "admin");
        }
    }
}

