/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.admin.user.DeleteUserPage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.plugin.ProjectPermissionKey;
import com.atlassian.jira.webtests.WebTestCaseWrapper;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

@WebTest(value={Category.FUNC_TEST, Category.PERMISSIONS, Category.USERS_AND_GROUPS})
public class TestDeleteUserAndPermissions
extends FuncTestCase {
    private static final String TWO_PROJECTS_WITH_SUBSCRIPTIONS = "TestDeleteUserAndPermissions.xml";

    @Override
    protected void setUpTest() {
        this.administration.restoreData(TWO_PROJECTS_WITH_SUBSCRIPTIONS);
        this.administration.addGlobalPermission(33, "jira-users");
        this.backdoor.darkFeatures().enableForSite("jira.no.frother.reporter.field");
    }

    @Override
    protected void tearDownTest() {
        this.backdoor.darkFeatures().disableForSite("jira.no.frother.reporter.field");
        this.administration.removeGlobalPermission(33, "jira-users");
    }

    public void testDeleteUserNotPossibleWithAssignedIssue() {
        WebTestCaseWrapper.logSection("Test Delete User Not Possible With Assigned Issue");
        this.log("Making sure that you can't see the other issue");
        this.navigation.issueNavigator().displayAllIssues();
        this.tester.assertTextPresent("Seen issue");
        this.tester.assertTextNotPresent("Unseen issue");
        this.log("Ensuring that you're unable to delete fred and that the correct number of issues are shown");
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParameters("fred"));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeletionError(), (Matcher)Matchers.equalTo((Object)deleteUserPage.getUserCannotBeDeleteMessage("fred")));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromErrorFieldNamed(DeleteUserPage.ASSIGNED_ISSUES), (Matcher)Matchers.equalTo((Object)"1"));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromErrorFieldNamed(DeleteUserPage.REPORTED_ISSUES), (Matcher)Matchers.equalTo((Object)"2"));
        MatcherAssert.assertThat((Object)deleteUserPage.getNumberFromWarningFieldNamed(DeleteUserPage.SHARED_FILTERS), (Matcher)Matchers.equalTo((Object)"1"));
    }

    public void testDeleteUserRemoveFromPermissionAndNotificationSchemes() {
        WebTestCaseWrapper.logSection("Test delete user with shared filters");
        this.assertFredHasPermissionsAssigned();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("Test Issue Security Scheme");
        this.tester.assertTextPresent("fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.tester.assertTextPresent("fred");
        this.tester.assertLinkPresent("del_10050");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLink("10000_edit");
        this.tester.clickLink("add_perm_" + ProjectPermissions.EDIT_ISSUES.permissionKey());
        this.tester.checkCheckbox("type", "user");
        this.tester.setFormElement("user", "admin");
        this.tester.submit(" Add ");
        this.tester.clickLink("add_perm_" + ProjectPermissions.BROWSE_PROJECTS.permissionKey());
        this.tester.checkCheckbox("type", "user");
        this.tester.setFormElement("user", "admin");
        this.tester.submit(" Add ");
        this.tester.clickLink("add_perm_" + ProjectPermissions.MODIFY_REPORTER.permissionKey());
        this.tester.checkCheckbox("type", "user");
        this.tester.setFormElement("user", "admin");
        this.tester.submit(" Add ");
        this.navigation.issue().gotoIssue("HSP-1");
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("reporter", "admin");
        this.tester.submit("Update");
        this.navigation.issue().gotoIssue("MKY-1");
        this.tester.clickLink("edit-issue");
        this.tester.setFormElement("reporter", "admin");
        this.tester.selectOption("assignee", "Administrator");
        this.tester.submit("Update");
        this.log("Deleting Fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("fred");
        this.tester.clickLink("deleteuser_link");
        this.tester.assertTextPresent("Delete User");
        this.tester.submit("Delete");
        this.assertions.assertNodeByIdExists("user_browser_table");
        this.tester.assertTextNotPresent("fred");
        this.assertFredHasNoPermissionsAssigned();
        this.navigation.gotoAdminSection(Navigation.AdminSection.SECURITY_SCHEMES);
        this.tester.clickLinkWithText("Test Issue Security Scheme");
        this.tester.assertTextNotPresent("fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.NOTIFICATION_SCHEMES);
        this.tester.clickLinkWithText("Default Notification Scheme");
        this.tester.assertTextNotPresent("fred");
        this.tester.assertLinkNotPresent("del_10050");
    }

    public void testCannotSelfDestruct() {
        this.administration.restoreBlankInstance();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParametersWithXsrf("admin", this.page));
        MatcherAssert.assertThat((Object)deleteUserPage.getUserDeleteSelfError(), (Matcher)Matchers.equalTo((Object)"You cannot delete the currently logged in user."));
        deleteUserPage.confirmNoDeleteButtonPresent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAdminCannotDeleteSysadmin() {
        this.administration.restoreBlankInstance();
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        try {
            this.administration.usersAndGroups().addUser("sysadmin2");
            this.administration.usersAndGroups().addUserToGroup("sysadmin2", "jira-administrators");
            this.administration.usersAndGroups().addUser("nonsystemadmin");
            this.administration.usersAndGroups().addGroup("nonsystemadmins");
            this.administration.usersAndGroups().addUserToGroup("nonsystemadmin", "nonsystemadmins");
            this.administration.addGlobalPermission(0, "nonsystemadmins");
            this.navigation.login("nonsystemadmin");
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.assertLinkNotPresent("deleteuser_link_sysadmin2");
            DeleteUserPage deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParametersWithXsrf("sysadmin2", this.page));
            MatcherAssert.assertThat((Object)deleteUserPage.getNonAdminDeletingSysAdminErrorMessage(), (Matcher)Matchers.equalTo((Object)"As a user with JIRA Administrators permission, you cannot delete users with JIRA System Administrators permission."));
            deleteUserPage.confirmNoDeleteButtonPresent();
            deleteUserPage = this.navigation.gotoPageWithParams(DeleteUserPage.class, DeleteUserPage.generateDeleteQueryParametersWithXsrf("sysadmin2", this.page) + "&confirm=true");
            MatcherAssert.assertThat((Object)deleteUserPage.getNonAdminDeletingSysAdminErrorMessage(), (Matcher)Matchers.equalTo((Object)"As a user with JIRA Administrators permission, you cannot delete users with JIRA System Administrators permission."));
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.assertLinkPresent("sysadmin2");
        }
        finally {
            this.navigation.login("admin");
        }
    }

    private void assertFredHasPermissionsAssigned() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText("Default Permission Scheme");
        this.tester.assertTextNotPresent("fred");
        this.tester.assertTextNotPresent("Fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText("Fred's scheme");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.ADMINISTER_PROJECTS.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.BROWSE_PROJECTS.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.CREATE_ISSUES.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.EDIT_ISSUES.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.SCHEDULE_ISSUES.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.MOVE_ISSUES.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.ASSIGNABLE_USER.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.RESOLVE_ISSUES.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.CLOSE_ISSUES.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.MODIFY_REPORTER.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.ADD_COMMENTS.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.DELETE_ALL_COMMENTS.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.DELETE_ISSUES.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.WORK_ON_ISSUES.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.LINK_ISSUES.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.CREATE_ATTACHMENTS.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.DELETE_ALL_ATTACHMENTS.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.VIEW_DEV_TOOLS.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.VIEW_VOTERS_AND_WATCHERS.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.MANAGE_WATCHERS.permissionKey() + "_fred");
        this.tester.assertLinkPresent("del_perm_" + ProjectPermissions.SET_ISSUE_SECURITY.permissionKey() + "_fred");
    }

    private void assertFredHasNoPermissionsAssigned() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText("Default Permission Scheme");
        this.tester.assertTextNotPresent("fred");
        this.tester.assertTextNotPresent("Fred");
        this.navigation.gotoAdminSection(Navigation.AdminSection.PERMISSION_SCHEMES);
        this.tester.clickLinkWithText("Fred's scheme");
        this.tester.assertTextNotPresent("fred");
        for (ProjectPermissionKey key : TestDeleteUserAndPermissions.systemProjectPermissionKeys()) {
            this.tester.assertLinkNotPresent("del_perm_" + key.permissionKey() + "_fred");
        }
    }

    private static Collection<ProjectPermissionKey> systemProjectPermissionKeys() {
        return Arrays.asList(ProjectPermissions.ADMINISTER_PROJECTS, ProjectPermissions.BROWSE_PROJECTS, ProjectPermissions.VIEW_DEV_TOOLS, ProjectPermissions.VIEW_READONLY_WORKFLOW, ProjectPermissions.CREATE_ISSUES, ProjectPermissions.EDIT_ISSUES, ProjectPermissions.TRANSITION_ISSUES, ProjectPermissions.SCHEDULE_ISSUES, ProjectPermissions.MOVE_ISSUES, ProjectPermissions.ASSIGN_ISSUES, ProjectPermissions.ASSIGNABLE_USER, ProjectPermissions.RESOLVE_ISSUES, ProjectPermissions.CLOSE_ISSUES, ProjectPermissions.MODIFY_REPORTER, ProjectPermissions.DELETE_ISSUES, ProjectPermissions.LINK_ISSUES, ProjectPermissions.SET_ISSUE_SECURITY, ProjectPermissions.VIEW_VOTERS_AND_WATCHERS, ProjectPermissions.MANAGE_WATCHERS, ProjectPermissions.ADD_COMMENTS, ProjectPermissions.EDIT_ALL_COMMENTS, ProjectPermissions.EDIT_OWN_COMMENTS, ProjectPermissions.DELETE_ALL_COMMENTS, ProjectPermissions.DELETE_OWN_COMMENTS, ProjectPermissions.CREATE_ATTACHMENTS, ProjectPermissions.DELETE_ALL_ATTACHMENTS, ProjectPermissions.DELETE_OWN_ATTACHMENTS, ProjectPermissions.WORK_ON_ISSUES, ProjectPermissions.EDIT_OWN_WORKLOGS, ProjectPermissions.EDIT_ALL_WORKLOGS, ProjectPermissions.DELETE_OWN_WORKLOGS, ProjectPermissions.DELETE_ALL_WORKLOGS);
    }
}

