/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.user;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.WebPageLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.framework.util.form.FormParameterUtil;
import com.atlassian.jira.webtests.EmailFuncTestCase;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import java.io.IOException;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.junit.Ignore;

@WebTest(value={Category.FUNC_TEST, Category.USERS_AND_GROUPS})
public class TestAddUser
extends EmailFuncTestCase {
    private static final String CREATE_USER_SUBMIT = "Create";
    private static final String TEST_USERNAME = "user";
    private static final String TEST_FULL_NAME = "User Tested";
    private static final String TEST_EMAIL = "username@email.com";
    private static final String TEST_PASSWORD = "evilwoman";

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreBlankInstance();
    }

    public void testEmptyData() {
        this.buildUser("", "", "");
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent("Create New User");
        this.tester.assertTextPresent("You must specify a username.");
        this.tester.assertTextPresent("You must specify a full name.");
        this.tester.assertTextPresent("You must specify an email address.");
    }

    public void testCreateDuplicateUser() {
        this.checkSuccessUserCreate(false);
        this.buildUser(TEST_USERNAME, TEST_FULL_NAME, TEST_EMAIL);
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent("A user with that username already exists.");
    }

    public void testCreateUserSuccess() {
        this.checkSuccessUserCreate(false);
    }

    public void testCreateUserInvalidEmail() {
        this.buildUser(TEST_USERNAME, TEST_FULL_NAME, "username.email.com");
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent("You must specify a valid email address.");
    }

    public void testCreateUserPassword() {
        this.buildUser(TEST_USERNAME, TEST_FULL_NAME, TEST_EMAIL);
        this.tester.setFormElement("password", "password");
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent("Your password and confirmation password do not match.");
        this.tester.setFormElement("confirm", "confirm");
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent("Your password and confirmation password do not match.");
        this.tester.setFormElement("password", "abc");
        this.tester.setFormElement("confirm", "def");
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent("Your password and confirmation password do not match.");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent("User: User Tested");
        String[] userDetails = new String[]{"Username:", TEST_USERNAME, "Full Name:", TEST_FULL_NAME, "Email:", TEST_EMAIL};
        this.text.assertTextSequence(new WebPageLocator(this.tester), userDetails);
    }

    public void testNoPermission() {
        this.navigation.logout();
        this.navigation.login("fred", "fred");
        this.tester.gotoPage("http://localhost:8090/jira/secure/admin/user/AddUser!default.jspa");
        this.tester.assertTextPresent("Welcome to jWebTest JIRA installation");
        this.tester.assertTextNotPresent("Project: newproject");
        this.tester.assertTextNotPresent("Add a new project");
    }

    @Ignore(value="JRADEV-8029 Can no longer do this in a simple func test. Need to make User Directories read-only")
    public void testCreateUserExternalUserConfiguration() {
        this.administration.generalConfiguration().setExternalUserManagement(true);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.assertLinkNotPresent("create_user");
        this.tester.assertTextNotPresent("Create User");
        this.administration.generalConfiguration().setExternalUserManagement(false);
        this.checkSuccessUserCreate(false);
    }

    public void testCreateUserEmailSent() throws InterruptedException, IOException, MessagingException {
        this.configureAndStartSmtpServer();
        this.checkSuccessUserCreate(true);
        this.flushMailQueueAndWait(1);
        MimeMessage[] mimeMessages = this.mailService.getReceivedMessages();
        TestAddUser.assertEquals((int)1, (int)mimeMessages.length);
        MimeMessage msg = mimeMessages[0];
        String body = msg.getContent().toString();
        this.assertEmailBodyContainsLine(msg, TEST_USERNAME);
        this.assertEmailBodyContainsLine(msg, TEST_FULL_NAME);
        this.assertEmailBodyContains(msg, TEST_EMAIL);
        this.assertEmailBodyContains(msg, "Get started by setting your own password and logging in");
        this.assertEmailBodyContains(msg, "secure/ResetPassword!default.jspa?os_username=user&amp;token=");
        this.assertEmailBodyDoesntContain(msg, TEST_PASSWORD);
    }

    private void buildUser(String username, String fullName, String email) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("create_user");
        this.tester.assertTextPresent("Create New User");
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("fullname", fullName);
        this.tester.setFormElement("email", email);
    }

    private void checkSuccessUserCreate(boolean sendEmail) {
        this.buildUser(TEST_USERNAME, TEST_FULL_NAME, TEST_EMAIL);
        this.tester.setFormElement("password", TEST_PASSWORD);
        this.tester.setFormElement("confirm", TEST_PASSWORD);
        if (sendEmail) {
            this.tester.checkCheckbox("sendEmail", "true");
        }
        this.tester.submit(CREATE_USER_SUBMIT);
        this.tester.assertTextPresent("User: User Tested");
        String[] userDetails = new String[]{"Username:", TEST_USERNAME, "Full Name:", TEST_FULL_NAME, "Email:", TEST_EMAIL};
        this.text.assertTextSequence(new WebPageLocator(this.tester), userDetails);
    }

    public void testNewUsersAreNotGivenAdminRights() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
        this._addPermissionToGroup("USE", "jira-administrators");
        this.tester.assertElementNotPresent("del_USE_jira-administrators");
        this._addPermissionToGroup("CREATE_SHARED_OBJECTS", "jira-users");
        this.tester.assertElementPresent("del_CREATE_SHARED_OBJECTS_jira-users");
        this.checkSuccessUserCreate(false);
        this.navigation.logout();
        this.navigation.login(TEST_USERNAME, TEST_PASSWORD);
        this.tester.assertElementNotPresent("admin_link");
        this.tester.gotoPage("/secure/ViewProfile.jspa");
        this.tester.assertTextPresent("jira-users");
        this.tester.assertTextNotPresent("jira-administrators");
        this.tester.assertTextNotPresent("jira-developers");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNewUsersNotAddedToNestedGroups() {
        try {
            this.addEditNestedGroups();
            this.checkSuccessUserCreate(false);
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
            this.tester.clickLink(TEST_USERNAME);
            this.tester.assertTextPresent("jira-users");
            this.tester.assertTextNotPresent("accounts");
            this.tester.assertTextNotPresent("sales");
            this.tester.assertTextNotPresent("customer-service");
        }
        finally {
            this.resetAdminPassword();
        }
    }

    private void _addPermissionToGroup(String PermissionType, String group) {
        this.tester.setFormElement("globalPermType", PermissionType);
        FormParameterUtil formParameterUtil = new FormParameterUtil(this.tester, "jiraform", "Add");
        formParameterUtil.addOptionToHtmlSelect("groupName", new String[]{group});
        formParameterUtil.setFormElement("groupName", group);
        formParameterUtil.submitForm();
        this.navigation.gotoAdminSection(Navigation.AdminSection.GLOBAL_PERMISSIONS);
    }

    private void addEditNestedGroups() {
        this.toggleNestedGroups(true);
        this.addGroup("accounts");
        this.addGroup("sales");
        this.addGroup("customer-service");
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.clickLink("edit_nested_groups");
        this.tester.assertTextPresent("This page allows you to edit nested group memberships.");
        this.tester.setWorkingForm("jiraform");
        this.selectMultiOption("selectedGroupsStr", "jira-users");
        this.selectMultiOption("childrenToAssignStr", "accounts");
        this.selectMultiOption("childrenToAssignStr", "sales");
        this.selectMultiOption("childrenToAssignStr", "customer-service");
        this.tester.submit("assign");
    }

    public void selectMultiOption(String selectName, String option) {
        String value = this.tester.getDialog().getValueForOption(selectName, option);
        this.tester.checkCheckbox(selectName, value);
    }

    private void addGroup(String groupName) {
        this.navigation.gotoAdminSection(Navigation.AdminSection.GROUP_BROWSER);
        this.tester.setFormElement("addName", groupName);
        this.tester.submit("add_group");
    }

    public void toggleNestedGroups(boolean enable) {
        this.navigation.gotoAdmin();
        this.tester.gotoPage("/plugins/servlet/embedded-crowd/directories/list");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        WebLink link = userDirectoryTable.getTableCell(1, 4).getLinkWith("edit");
        this.navigation.clickLink(link);
        if (enable) {
            this.tester.checkCheckbox("nestedGroupsEnabled", "true");
        } else {
            this.tester.checkCheckbox("nestedGroupsEnabled", "false");
        }
        this.tester.submit("save");
    }

    public void resetAdminPassword() {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("admin");
        this.tester.clickLinkWithText("Set Password");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.submit("Update");
    }

    private boolean find(String s, Pattern pattern) {
        return pattern.matcher(s).find();
    }
}

