/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.DashboardControl;
import com.atlassian.jira.testkit.client.SearchRequestControl;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTasks752To754
extends FuncTestCase {
    public void testUpgrade() {
        this.administration.restoreDataWithBuildNumber("TestUpgradeTasks752To754.xml", 721);
        this.checkDashboardsUpgradedCorrectly();
        this.checkSearchRequestsUpgradedCorrectly();
    }

    private void checkDashboardsUpgradedCorrectly() {
        TestUpgradeTasks752To754.assertSharedEntitiesEqual(TestUpgradeTasks752To754.createdSharedBeans(), this.getServerDashboards());
    }

    private void checkSearchRequestsUpgradedCorrectly() {
        TestUpgradeTasks752To754.assertSharedEntitiesEqual(TestUpgradeTasks752To754.createdSharedBeans(), this.getServerFilters());
    }

    private static List<SharedEntity> createdSharedBeans() {
        ArrayList<SharedEntity> searchBeans = new ArrayList<SharedEntity>();
        searchBeans.add(new SharedEntity("b", "testuser", 1L, true));
        searchBeans.add(new SharedEntity("bb", "testuser", 1L, true));
        searchBeans.add(new SharedEntity("c", "testuser", 1L, true));
        searchBeans.add(new SharedEntity("cc", "testuser", 1L, true));
        searchBeans.add(new SharedEntity("d", "testuser", 0L, false));
        searchBeans.add(new SharedEntity("dd", "testuser", 0L, false));
        searchBeans.add(new SharedEntity("e", "testuser", 1L, true));
        searchBeans.add(new SharedEntity("ee", "testuser", 1L, true));
        searchBeans.add(new SharedEntity("f", "testuser", 0L, false));
        searchBeans.add(new SharedEntity("ff", "testuser", 0L, false));
        return searchBeans;
    }

    private ImmutableList<SharedEntity> getServerDashboards() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.backdoor.dashboard().getOwnedDashboard("testuser"), (Function)new Function<DashboardControl.Dashboard, SharedEntity>(){

            public SharedEntity apply(DashboardControl.Dashboard input) {
                return new SharedEntity(input.getName(), input.getOwner(), input.getFavouriteCount(), input.isFavourite());
            }
        }));
    }

    private ImmutableList<SharedEntity> getServerFilters() {
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)this.backdoor.searchRequests().getOwnedFilters("testuser"), (Function)new Function<SearchRequestControl.SearchBean, SharedEntity>(){

            public SharedEntity apply(SearchRequestControl.SearchBean input) {
                return new SharedEntity(input.getSearchName(), input.getUsername(), input.getFavouriteCount(), input.isFavourite());
            }
        }));
    }

    private static void assertSharedEntitiesEqual(List<? extends SharedEntity> expected, List<? extends SharedEntity> actual) {
        int pos = 0;
        ListIterator<? extends SharedEntity> actualIter = actual.listIterator();
        ListIterator<? extends SharedEntity> expectedIter = expected.listIterator();
        while (actualIter.hasNext() && expectedIter.hasNext()) {
            SharedEntity actualEntity = actualIter.next();
            SharedEntity expectedEntity = expectedIter.next();
            if (!StringUtils.equals((String)actualEntity.getName(), (String)expectedEntity.getName())) {
                TestUpgradeTasks752To754.fail((String)String.format("[%d].name != [%1$d].name (%s != %s).", pos, expectedEntity.getName(), actualEntity.getName()));
            }
            if (actualEntity.isFavourite() != expectedEntity.isFavourite()) {
                TestUpgradeTasks752To754.fail((String)String.format("[%d].favourite != [%1$d].favourite (%s != %s).", pos, expectedEntity.isFavourite(), actualEntity.isFavourite()));
            }
            if (actualEntity.getFavouriteCount() != expectedEntity.getFavouriteCount()) {
                TestUpgradeTasks752To754.fail((String)String.format("[%d].favouriteCount != [%1$d].favouriteCount (%s != %s).", pos, expectedEntity.getFavouriteCount(), actualEntity.getFavouriteCount()));
            }
            if (!StringUtils.equals((String)actualEntity.getOwner(), (String)expectedEntity.getOwner())) {
                TestUpgradeTasks752To754.fail((String)String.format("[%d].owner != [%1$d].owner (%s != %s).", pos, expectedEntity.getOwner(), actualEntity.getOwner()));
            }
            ++pos;
        }
        if (actualIter.hasNext()) {
            TestUpgradeTasks752To754.fail((String)String.format("Got extra dashboards: [%s]", actual.subList(pos, actual.size())));
        } else if (expectedIter.hasNext()) {
            TestUpgradeTasks752To754.fail((String)String.format("Didn't get dashboards: [%s]", expected.subList(pos, expected.size())));
        }
    }

    private static class SharedEntity {
        private final String name;
        private final String owner;
        private final long favouriteCount;
        private final boolean favourite;

        private SharedEntity(String name, String owner, long favouriteCount, boolean favourite) {
            this.name = name;
            this.owner = owner;
            this.favouriteCount = favouriteCount;
            this.favourite = favourite;
        }

        public String getName() {
            return this.name;
        }

        public String getOwner() {
            return this.owner;
        }

        public long getFavouriteCount() {
            return this.favouriteCount;
        }

        public boolean isFavourite() {
            return this.favourite;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SharedEntity that = (SharedEntity)o;
            if (this.favourite != that.favourite) {
                return false;
            }
            if (this.favouriteCount != that.favouriteCount) {
                return false;
            }
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                return false;
            }
            return !(this.owner != null ? !this.owner.equals(that.owner) : that.owner != null);
        }

        public int hashCode() {
            int result = this.name != null ? this.name.hashCode() : 0;
            result = 31 * result + (this.owner != null ? this.owner.hashCode() : 0);
            result = 31 * result + (int)(this.favouriteCount ^ this.favouriteCount >>> 32);
            result = 31 * result + (this.favourite ? 1 : 0);
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

