/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask813
extends FuncTestCase {
    private static final String SHORT_WORKFLOW_NAME = "TestUpgradeTask761/inactive-workflow-drafts-present.xml";
    private static final String LONG_WORKFLOW_NAME = "TestUpgradeTask761/inactive-workflow-drafts-present-long-parent-workflow-name.xml";
    private static final String LONG_WORKFLOW_NAME_AND_COPY_PRESENT = "TestUpgradeTask761/inactive-workflow-drafts-present-long-parent-workflow-name-copy-present.xml";

    public void testBackupCopiesShouldBeCreatedForAllInactiveWorkflowDrafts() {
        this.administration.restoreDataWithBuildNumber(SHORT_WORKFLOW_NAME, 700);
        TestUpgradeTask813.assertTrue((boolean)this.administration.workflows().goTo().inactive().contains("Copy of Workflow1"));
    }

    public void testAllInactiveWorkflowDraftsAreRemoved() {
        this.administration.restoreDataWithBuildNumber(SHORT_WORKFLOW_NAME, 700);
        TestUpgradeTask813.assertTrue((boolean)this.administration.workflows().goTo().inactive().drafts().isEmpty());
    }

    public void testNameOfTheADraftCopyDoesNotExceedTheMaxNumberOfAllowedCharsWhenTheNameOfTheParentContainsTheMaxNumberOfAllowedChars() {
        String expectedDraftWorkflowCopyName = "Copy of Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi condimentum ornare eros ut adipiscing. In hac habitasse platea dictumst. Cras mattis euismod mi. In elit arcu, placerat at placerat lacinia, molestie id mauris. Curabitur eu lacus a...";
        this.administration.restoreDataWithBuildNumber(LONG_WORKFLOW_NAME, 700);
        TestUpgradeTask813.assertTrue((boolean)this.administration.workflows().goTo().inactive().contains("Copy of Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi condimentum ornare eros ut adipiscing. In hac habitasse platea dictumst. Cras mattis euismod mi. In elit arcu, placerat at placerat lacinia, molestie id mauris. Curabitur eu lacus a..."));
    }

    public void testNameOfTheADraftCopyDoesNotExceedTheMaxNumberOfAllowedCharsWhenTheNameOfTheParentContainsTheMaxNumberOfAllowedCharsAndACopyOfTheParentAlsoExists() {
        String expectedDraftWorkflowCopyName = "Copy 2 of Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi condimentum ornare eros ut adipiscing. In hac habitasse platea dictumst. Cras mattis euismod mi. In elit arcu, placerat at placerat lacinia, molestie id mauris. Curabitur eu lacus...";
        this.administration.restoreDataWithBuildNumber(LONG_WORKFLOW_NAME_AND_COPY_PRESENT, 700);
        TestUpgradeTask813.assertTrue((boolean)this.administration.workflows().goTo().inactive().contains("Copy 2 of Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi condimentum ornare eros ut adipiscing. In hac habitasse platea dictumst. Cras mattis euismod mi. In elit arcu, placerat at placerat lacinia, molestie id mauris. Curabitur eu lacus..."));
    }
}

