/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.IssueClient;
import com.atlassian.jira.testkit.client.restclient.RemoteIssueLink;
import com.atlassian.jira.util.collect.CollectionBuilder;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask707
extends FuncTestCase {
    public void testUpgradeTaskMigratesIncomingTrackbacksToIssueLinksIfTrackbacksWereEnabledInTheDatabase() {
        this.restoreDataWithVersionCheck("TestUpgradeTask707/trackbacks-enabled-by-database-value.xml");
        IssueClient issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        List remoteIssueLinks = issueClient.getRemoteIssueLinks("BULK-3");
        CollectionBuilder<RemoteIssueLink> builder = CollectionBuilder.newBuilder();
        builder.add(this.createLink(10010, "My Excerpt", "Foo Bar", "http://www.bar.com/", "Foo"));
        builder.add(this.createLink(10011, "<iframe src=\"http://www", "Foo Bar", "http://www.bar2.com/", null));
        builder.add(this.createLink(10012, "ssss", "Foo Bar", "http://www.bar3.com/", "<iframe "));
        builder.add(this.createLink(10020, "Excerpt", "Test", "http://www.google1.com", "Blog N"));
        List expected = builder.asList();
        TestUpgradeTask707.assertEquals((int)expected.size(), (int)remoteIssueLinks.size());
        this.compareLinks((RemoteIssueLink)expected.get(0), (RemoteIssueLink)remoteIssueLinks.get(0));
        this.compareLinks((RemoteIssueLink)expected.get(1), (RemoteIssueLink)remoteIssueLinks.get(1));
        this.compareLinks((RemoteIssueLink)expected.get(2), (RemoteIssueLink)remoteIssueLinks.get(2));
        this.compareLinks((RemoteIssueLink)expected.get(3), (RemoteIssueLink)remoteIssueLinks.get(3));
    }

    public void testUpgradeTaskMigratesIncomingTrackbacksToIssueLinksIfTrackbacksWereEnabledDueToTheDefaultValue() {
        this.restoreDataWithVersionCheck("TestUpgradeTask707/trackbacks-enabled-by-default-property-value.xml");
        IssueClient issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        List remoteIssueLinks = issueClient.getRemoteIssueLinks("BULK-3");
        CollectionBuilder<RemoteIssueLink> builder = CollectionBuilder.newBuilder();
        builder.add(this.createLink(10010, "My Excerpt", "Foo Bar", "http://www.bar.com/", "Foo"));
        builder.add(this.createLink(10011, "<iframe src=\"http://www", "Foo Bar", "http://www.bar2.com/", null));
        builder.add(this.createLink(10012, "ssss", "Foo Bar", "http://www.bar3.com/", "<iframe "));
        builder.add(this.createLink(10020, "Excerpt", "Test", "http://www.google1.com", "Blog N"));
        List expected = builder.asList();
        TestUpgradeTask707.assertEquals((int)expected.size(), (int)remoteIssueLinks.size());
        this.compareLinks((RemoteIssueLink)expected.get(0), (RemoteIssueLink)remoteIssueLinks.get(0));
        this.compareLinks((RemoteIssueLink)expected.get(1), (RemoteIssueLink)remoteIssueLinks.get(1));
        this.compareLinks((RemoteIssueLink)expected.get(2), (RemoteIssueLink)remoteIssueLinks.get(2));
        this.compareLinks((RemoteIssueLink)expected.get(3), (RemoteIssueLink)remoteIssueLinks.get(3));
    }

    public void testUpgradeTaskDoesNotMigrateTrackbacksToIssueLinksIfTrackbacksWereDisabledInTheDatabase() {
        this.restoreDataWithVersionCheck("TestUpgradeTask707/trackbacks-disabled-by-database-value.xml");
        IssueClient issueClient = new IssueClient((JIRAEnvironmentData)this.getEnvironmentData());
        List remoteIssueLinks = issueClient.getRemoteIssueLinks("BULK-3");
        TestUpgradeTask707.assertTrue((String)"Trackbacks should not have been converted, yet some remote links exist", (boolean)remoteIssueLinks.isEmpty());
    }

    private void restoreDataWithVersionCheck(String xmlFile) {
        this.administration.restoreDataWithBuildNumber(xmlFile, 660);
    }

    private void compareLinks(RemoteIssueLink l1, RemoteIssueLink l2) {
        TestUpgradeTask707.assertEquals((String)("Links relationship is different for link: " + l2.id), (String)l1.relationship, (String)l2.relationship);
        TestUpgradeTask707.assertEquals((String)("Links globalid is different for link: " + l2.id), (String)l1.globalId, (String)l2.globalId);
        TestUpgradeTask707.assertEquals((String)("Links applicationType is different for link: " + l2.id), (String)l1.application.type, (String)l2.application.type);
        TestUpgradeTask707.assertEquals((String)("Links applicationName is different for link: " + l2.id), (String)l1.application.name, (String)l2.application.name);
        TestUpgradeTask707.assertEquals((String)("Links summary is different for link: " + l2.id), (String)l1.object.summary, (String)l2.object.summary);
        TestUpgradeTask707.assertEquals((String)("Links title is different for link: " + l2.id), (String)l1.object.title, (String)l2.object.title);
        TestUpgradeTask707.assertEquals((String)("Links url is different for link: " + l2.id), (String)l1.object.url, (String)l2.object.url);
    }

    private RemoteIssueLink createLink(int id, String summary, String title, String url, String blogName) {
        RemoteIssueLink link = new RemoteIssueLink();
        link.globalId = "com.atlassian.jira:legacy-trackbacks-" + id;
        link.application = new RemoteIssueLink.Application();
        link.application.type = "legacy-trackbacks";
        link.application.name = blogName;
        link.relationship = "Trackbacks";
        link.object = new RemoteIssueLink.RemoteObject();
        link.object.summary = summary;
        link.object.title = title;
        link.object.url = url;
        return link;
    }

    private static class Backups {
        private Backups() {
        }

        private static class TrackbacksDisabledBy {
            private static final String DATABASE_VALUE = "TestUpgradeTask707/trackbacks-disabled-by-database-value.xml";

            private TrackbacksDisabledBy() {
            }
        }

        private static class TrackbacksEnabledBy {
            private static final String DATABASE_VALUE = "TestUpgradeTask707/trackbacks-enabled-by-database-value.xml";
            private static final String DEFAULT_PROPERTY_VALUE = "TestUpgradeTask707/trackbacks-enabled-by-default-property-value.xml";

            private TrackbacksEnabledBy() {
            }
        }
    }
}

