/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.ConditionClassMatcher;
import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import java.io.InputStream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask701
extends FuncTestCase {
    static final String XML_BACKUP = "TestUpgradeTask701.xml";

    public void testUpgradeTaskRemovesReferencesToOSUserGroupCondition() throws Exception {
        this.administration.restoreDataWithBuildNumber(XML_BACKUP, 700);
        WebResponse upgraded = this.tester.getDialog().getWebClient().getResponse((WebRequest)new GetMethodWebRequest(this.getEnvironmentData().getBaseUrl() + "/secure/admin/workflows/ViewWorkflowXml.jspa?workflowMode=live&workflowName=Workflow+that+uses+OSUserGroupCondition"));
        InputStream workflow = upgraded.getInputStream();
        Assert.assertThat((Object)workflow, (Matcher)CoreMatchers.not((Matcher)ConditionClassMatcher.usesConditionClass("com.opensymphony.workflow.util.OSUserGroupCondition")));
        workflow.reset();
        Assert.assertThat((Object)workflow, (Matcher)ConditionClassMatcher.usesConditionClass("com.atlassian.jira.workflow.condition.UserInGroupCondition"));
        String key = "HSP-1";
        this.navigation.issue().viewIssue(key);
        this.text.assertTextPresent(this.locator.css(".issueaction-workflow-transition"), "Close Issue");
        this.navigation.login("fred");
        this.text.assertTextNotPresent(this.locator.css(".issueaction-workflow-transition"), "Close Issue");
    }
}

