/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.webtests.LicenseKeys;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask641
extends FuncTestCase {
    public static final String ROWF_PROJECT_NAME = "readOnlyWorkflowTest";
    public static final String ROWF_PROJECT_KEY = "ROWFT";
    public static final String ROWF_ISSUE_KEY = "ROWFT-1";

    public void testUpgrade() {
        this.setupJIRAFromScratch();
        this.createProjectWithOneIssue();
        this.navigation.issue().viewIssue(ROWF_ISSUE_KEY);
        this.tester.assertLinkPresentWithText("View Workflow");
        this.administration.permissionSchemes().defaultScheme().removePermission(ProjectPermissions.VIEW_READONLY_WORKFLOW, "10000");
        this.navigation.issue().viewIssue(ROWF_ISSUE_KEY);
        this.tester.assertLinkNotPresentWithText("View Workflow");
    }

    private void setupJIRAFromScratch() {
        this.administration.restoreNotSetupInstance();
        this.tester.gotoPage("secure/SetupApplicationProperties.jspa");
        this.tester.assertTextPresent("Set Up Application Properties");
        this.tester.setWorkingForm("jira-setupwizard");
        this.tester.setFormElement("title", "My JIRA");
        this.tester.submit();
        this.tester.setWorkingForm("jira-setup-product-bundle");
        this.withHiddenFieldsTemporarilyEditable(new Runnable(){

            @Override
            public void run() {
                TestUpgradeTask641.this.tester.setFormElement("selectedBundle", "TRACKING");
            }
        });
        this.tester.submit();
        this.tester.setWorkingForm("setupLicenseForm");
        this.tester.setFormElement("setupLicenseKey", LicenseKeys.V2_COMMERCIAL.getLicenseString());
        this.tester.submit();
        this.tester.assertTextPresent("Set Up Administrator Account");
        this.tester.setFormElement("username", "admin");
        this.tester.setFormElement("password", "admin");
        this.tester.setFormElement("confirm", "admin");
        this.tester.setFormElement("fullname", "Mary Magdelene");
        this.tester.setFormElement("email", "admin@example.com");
        this.tester.submit();
        this.tester.assertTextPresent("Set Up Email Notifications");
        this.log("Noemail");
        this.tester.submit("finish");
        this.log("Noemail");
        this.tester.assertLinkPresent("header-details-user-fullname");
        this.navigation.disableWebSudo();
    }

    private void createProjectWithOneIssue() {
        this.administration.project().addProject(ROWF_PROJECT_NAME, ROWF_PROJECT_KEY, "admin");
        this.navigation.browseProject(ROWF_PROJECT_KEY);
        this.navigation.issue().goToCreateIssueForm(ROWF_PROJECT_NAME, "Bug");
        this.tester.assertTextPresent("CreateIssueDetails.jspa");
        this.tester.setWorkingForm("issue-create");
        this.tester.setFormElement("summary", "Test Issue for ReadOnly Workflow");
        this.tester.setFormElement("reporter", "admin");
        this.tester.submit();
    }

    private void withHiddenFieldsTemporarilyEditable(Runnable runnable) {
        boolean isHiddenFieldsEditable = this.tester.getDialog().getWebClient().getClientProperties().isHiddenFieldsEditable();
        if (!isHiddenFieldsEditable) {
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(true);
            runnable.run();
            this.tester.getDialog().getWebClient().getClientProperties().setHiddenFieldsEditable(isHiddenFieldsEditable);
        } else {
            runnable.run();
        }
    }
}

