/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.rules.RestRule;
import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.meterware.httpunit.WebResponse;
import java.io.IOException;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask64015
extends FuncTestCase {
    private RestRule restRule;

    @Override
    public void setUpTest() {
        this.restRule = new RestRule(this);
        this.restRule.before();
    }

    @Override
    public void tearDownTest() {
        this.restRule.after();
    }

    public void testBugzillaGadgetDeleted() throws IOException, SAXException, JSONException {
        this.administration.restoreData("TestUpgradeTask64015.xml");
        WebResponse response = this.restRule.GET("/rest/dashboards/1.0/10100.json");
        TestUpgradeTask64015.assertEquals((String)"application/json", (String)response.getContentType());
        JSONObject dashboard = new JSONObject(response.getText());
        this.assertNoBugzillaGadgetPresent(dashboard, 6);
    }

    private void assertNoBugzillaGadgetPresent(JSONObject contents, int expectedNumberOfGadgets) throws JSONException {
        JSONArray gadgets = contents.getJSONArray("gadgets");
        TestUpgradeTask64015.assertEquals((int)expectedNumberOfGadgets, (int)gadgets.length());
        for (int i = 0; i < gadgets.length(); ++i) {
            JSONObject gadget = gadgets.getJSONObject(i);
            TestUpgradeTask64015.assertFalse((boolean)gadget.getString("gadgetUrl").contains("bugzilla-id-search"));
        }
    }
}

