/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.page.ViewIssuePage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.util.collect.MapBuilder;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask6208
extends FuncTestCase {
    private Map<String, String> issueCreators;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.issueCreators = MapBuilder.newBuilder("HSP-1", "Anonymous").add("HSP-2", "Barney Rubble").add("HSP-3", "BamBam Rubble").add("HSP-4", "betty").add("HSP-5", "Fred Flinstone").add("HSP-6", "Pebble Flinstone").add("HSP-7", "Wilma Flinstone").add("HSP-8", "Wilma Flinstone").toMap();
    }

    public void testCreatorsCreatedAsExpected() {
        this.administration.restoreData("TestUpgradeTask6208.xml");
        for (Map.Entry<String, String> entry : this.issueCreators.entrySet()) {
            this.assertIssueCreator(entry.getKey(), entry.getValue());
        }
    }

    private void assertIssueCreator(String issueKey, String creator) {
        ViewIssuePage viewIssuePage = this.navigation.issue().viewIssue(issueKey).openTabWithId("changehistory-tabpanel");
        TestUpgradeTask6208.assertEquals((String)creator, (String)viewIssuePage.getCreatorUserName());
    }

    private List<String> getTextFromNodes(String selector) {
        Object[] nodes = this.locator.css(selector).getNodes();
        return Lists.transform((List)Lists.newArrayList((Object[])nodes), (Function)new Function<Node, String>(){

            public String apply(@Nullable Node item) {
                return item == null ? null : String.valueOf(item.getNodeValue());
            }
        });
    }
}

