/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.w3c.dom.Node;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask6206
extends FuncTestCase {
    private JiraRestClient restClient;

    @Override
    public void setUpTest() {
        this.restClient = this.createRestClient();
    }

    public void testStatusesAssignedAsExpected() {
        this.administration.restoreDataWithBuildNumber("JDEV-24290-TestStatusCategoryAssignment.xml", 6204);
        this.backdoor.darkFeatures().enableForSite("jira.issue.status.lozenge");
        this.navigation.gotoPage("/secure/admin/ViewStatuses.jspa");
        List<String> lozenges = this.getStatusNamesFromStatusLozengeClass(".jira-issue-status-lozenge");
        MatcherAssert.assertThat((Object)lozenges.size(), (Matcher)CoreMatchers.equalTo((Object)15));
        List<String> undefined = this.getStatusNamesFromStatusLozengeClass(".jira-issue-status-lozenge-undefined");
        MatcherAssert.assertThat((Object)undefined.size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)undefined.get(0), (Matcher)CoreMatchers.equalTo((Object)"The loneliest state"));
        List<String> done = this.getStatusNamesFromStatusLozengeClass(".jira-issue-status-lozenge-done");
        MatcherAssert.assertThat((Object)done.size(), (Matcher)CoreMatchers.equalTo((Object)4));
        MatcherAssert.assertThat(done, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)"Resolved"), CoreMatchers.equalTo((Object)"Closed"), CoreMatchers.equalTo((Object)"RCRT - Hired"), CoreMatchers.equalTo((Object)"RCRT - Rejected")}));
        List<String> todo = this.getStatusNamesFromStatusLozengeClass(".jira-issue-status-lozenge-new");
        MatcherAssert.assertThat((Object)todo.size(), (Matcher)CoreMatchers.equalTo((Object)3));
        MatcherAssert.assertThat(todo, (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{CoreMatchers.equalTo((Object)"Open"), CoreMatchers.equalTo((Object)"Reopened"), CoreMatchers.equalTo((Object)"RCRT - Resume Check")}));
    }

    private List<String> getStatusNamesFromStatusLozengeClass(String selector) {
        Object[] nodes = this.locator.css(selector).getNodes();
        return Lists.transform((List)Lists.newArrayList((Object[])nodes), (Function)new Function<Node, String>(){

            public String apply(@Nullable Node item) {
                return item == null ? null : String.valueOf(item.getParentNode().getPreviousSibling().getFirstChild().getNodeValue());
            }
        });
    }
}

