/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.IssueLink;
import com.atlassian.jira.rest.client.api.domain.IssueLinkType;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestUpgradeTask6152
extends FuncTestCase {
    private JiraRestClient restClient;

    @Override
    protected void setUpTest() {
        this.restClient = this.createRestClient();
    }

    public void testLegacyDirectionPropertyTrueIfClonersSwapped() {
        this.administration.restoreDataWithBuildNumber("ClonersMixedUp.xml", 6151);
        Iterable links = ((Issue)this.restClient.getIssueClient().getIssue("CLON-1").claim()).getIssueLinks();
        Assert.assertThat((Object)links, (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{this.issueLink("Cloners", IssueLinkType.Direction.INBOUND, "CLON-4"), this.issueLink("Cloners", IssueLinkType.Direction.INBOUND, "CLON-7")}));
    }

    private BaseMatcher<IssueLink> issueLink(final String linkType, final IssueLinkType.Direction linkDirection, final String linkedIssueKey) {
        return new BaseMatcher<IssueLink>(){

            public boolean matches(Object item) {
                return item instanceof IssueLink && ((IssueLink)item).getIssueLinkType().getName().equals(linkType) && ((IssueLink)item).getIssueLinkType().getDirection() == linkDirection && ((IssueLink)item).getTargetIssueKey().equals(linkedIssueKey);
            }

            public void describeTo(Description description) {
                description.appendText("Issue Link of type " + linkType + " " + linkDirection + " to issue " + linkedIssueKey);
            }
        };
    }
}

