/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.restclient.ProjectRole;
import com.atlassian.jira.testkit.client.restclient.ProjectRoleClient;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS, Category.PROJECTS, Category.ROLES})
public class TestUpgradeTask6134
extends FuncTestCase {
    private static final String EXPECTED_ACTORS = "[Actor[id=10020,type=atlassian-user-role-actor,name=Fred,displayName=Fred Normal],Actor[id=10021,type=atlassian-group-role-actor,name=jira-Developers,displayName=jira-Developers],Actor[id=10022,type=atlassian-user-role-actor,name=devO,displayName=Totes Devo]]";

    public void testProjectRolesCorrectForMixedCaseUsersAndGroups() throws IOException, SAXException {
        this.administration.restoreData("TestUpgradeTask6134.xml");
        ProjectRole role = new ProjectRoleClient((JIRAEnvironmentData)this.environmentData).get("HSP", "test role");
        TestUpgradeTask6134.assertEquals((String)EXPECTED_ACTORS, (String)TestUpgradeTask6134.toString(role.actors));
        this.navigation.gotoAdminSection(Navigation.AdminSection.PROJECT_ROLE_BROWSER);
        this.tester.clickLink("view_test role");
        this.text.assertTextSequence(this.locator.table("issuesecurityschemes").getText(), "Default Issue Security Scheme", "homosapien", "3 (View)");
    }

    private static String toString(List<ProjectRole.Actor> actors) {
        if (actors.isEmpty()) {
            return "[]";
        }
        ArrayList copy = Lists.newArrayList(actors);
        Collections.sort(copy, OrderById.INSTANCE);
        StringBuilder sb = new StringBuilder(256).append('[');
        for (ProjectRole.Actor actor : copy) {
            sb.append("Actor[id=").append(actor.id).append(",type=").append(actor.type).append(",name=").append(actor.name).append(",displayName=").append(actor.displayName).append("],");
        }
        sb.setCharAt(sb.length() - 1, ']');
        return sb.toString();
    }

    private static class OrderById
    implements Comparator<ProjectRole.Actor> {
        static final OrderById INSTANCE = new OrderById();

        private OrderById() {
        }

        @Override
        public int compare(ProjectRole.Actor o1, ProjectRole.Actor o2) {
            return o1.id.compareTo(o2.id);
        }
    }
}

