/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.testkit.beans.WorkflowSchemeData;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.testkit.client.restclient.IssueTransitionsMeta;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

@WebTest(value={Category.FUNC_TEST, Category.RENAME_USER, Category.UPGRADE_TASKS})
public class TestUpgradeTask6123
extends FuncTestCase {
    @Override
    public void setUpTest() {
        this.administration.restoreDataWithBuildNumber("JRADEV-21303-start-progress-without-assigning.xml", 6096);
    }

    public void testProjectWithoutWorkflowIsMigrated() {
        WorkflowSchemeData defaultScheme = this.backdoor.project().getSchemes((String)"NSAA").workflowScheme;
        TestUpgradeTask6123.assertEquals((String)"classic", (String)defaultScheme.getName());
    }

    public void testProjectSchemesMigratedToClassicWorkflow() {
        WorkflowSchemeData existingScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByName("Some jira, some custom, implicit default jira");
        TestUpgradeTask6123.assertEquals((String)"classic default workflow", (String)existingScheme.getDefaultWorkflow());
        TestUpgradeTask6123.assertEquals((String)"classic default workflow", (String)((String)existingScheme.getMappings().get("New Feature")));
        TestUpgradeTask6123.assertEquals((String)"custom", (String)((String)existingScheme.getMappings().get("Bug")));
    }

    public void testDraftProjectSchemesMigratedToClassicWorkflow() {
        WorkflowSchemeData schemeDraft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectName("I have a draft");
        TestUpgradeTask6123.assertEquals((String)"classic default workflow", (String)schemeDraft.getDefaultWorkflow());
        TestUpgradeTask6123.assertEquals((String)"classic default workflow", (String)((String)schemeDraft.getMappings().get("Bug")));
        TestUpgradeTask6123.assertEquals((String)"custom", (String)((String)schemeDraft.getMappings().get("New Feature")));
    }

    public void testDraftDefaultProjectSchemeGetsMigrated() {
        WorkflowSchemeData schemeDraft = this.backdoor.workflowSchemes().getWorkflowSchemeDraftByProjectName("All explicit jira default");
        TestUpgradeTask6123.assertEquals((String)"classic default workflow", (String)schemeDraft.getDefaultWorkflow());
    }

    public void testProjectSchemesWithDefaultKeepDefault() {
        WorkflowSchemeData existingScheme = this.backdoor.workflowSchemes().getWorkflowSchemeByName("Some jira, some custom, explicit default custom");
        TestUpgradeTask6123.assertEquals((String)"custom", (String)existingScheme.getDefaultWorkflow());
    }

    public void testNewProjectGetsNewDefaultWorkflow() {
        this.backdoor.project().addProject("I'm new", "IMNEW", "admin");
        TestUpgradeTask6123.assertEquals((String)"Default Workflow Scheme", (String)this.backdoor.project().getSchemes((String)"IMNEW").workflowScheme.getName());
    }

    public void testOldProjectRetainsStartAndStopProgressRestrictions() {
        this.backdoor.usersAndGroups().addUser("danny", "danny", "Danny Developer", "danny@example.com");
        this.backdoor.usersAndGroups().addUserToGroup("danny", "jira-developers");
        this.backdoor.issues().createIssue("NSAA", "brand new issue");
        TestUpgradeTask6123.assertFalse((String)"fred (not the assignee) shouldn't be able to start progress", (boolean)this.userCanSeeTransition("fred", "Start Progress", "NSAA-1"));
        TestUpgradeTask6123.assertFalse((String)"danny (not the assignee) shouldn't be able to start progress", (boolean)this.userCanSeeTransition("danny", "Start Progress", "NSAA-1"));
        this.navigation.login("admin");
        this.navigation.issue().gotoIssue("NSAA-1");
        this.tester.clickLinkWithText("Start Progress");
        TestUpgradeTask6123.assertFalse((String)"fred (not the assignee) shouldn't be able to stop progress", (boolean)this.userCanSeeTransition("fred", "Stop Progress", "NSAA-1"));
        TestUpgradeTask6123.assertFalse((String)"danny (not the assignee) shouldn't be able to stop progress", (boolean)this.userCanSeeTransition("danny", "Stop Progress", "NSAA-1"));
    }

    public void testNewProjectRelaxesStartAndStopProgressRestrictions() {
        this.backdoor.usersAndGroups().addUser("danny", "danny", "Danny Developer", "danny@example.com");
        this.backdoor.usersAndGroups().addUserToGroup("danny", "jira-developers");
        this.backdoor.project().addProject("I'm new", "IMNEW", "admin");
        this.backdoor.issues().createIssue("IMNEW", "brand new issue");
        TestUpgradeTask6123.assertFalse((String)"fred (not assignable) should not be able to start progress", (boolean)this.userCanSeeTransition("fred", "Start Progress", "IMNEW-1"));
        TestUpgradeTask6123.assertTrue((String)"danny (not the assignee) should be able to start progress", (boolean)this.userCanSeeTransition("danny", "Start Progress", "IMNEW-1"));
        this.navigation.login("admin");
        this.navigation.issue().gotoIssue("IMNEW-1");
        this.tester.clickLinkWithText("Start Progress");
        TestUpgradeTask6123.assertFalse((String)"fred (not assignable) should not be able to stop progress", (boolean)this.userCanSeeTransition("fred", "Stop Progress", "IMNEW-1"));
        TestUpgradeTask6123.assertTrue((String)"danny (assignable) should be able to stop progress", (boolean)this.userCanSeeTransition("danny", "Stop Progress", "IMNEW-1"));
    }

    private boolean userCanSeeTransition(String username, final String transitionTitle, String issueKey) {
        List availableTransitions = this.backdoor.issues().loginAs((String)username).getIssue((String)issueKey, (Issue.Expand[])new Issue.Expand[]{Issue.Expand.transitions}).transitions;
        return Iterables.any((Iterable)availableTransitions, (Predicate)new Predicate<IssueTransitionsMeta.Transition>(){

            public boolean apply(@Nullable IssueTransitionsMeta.Transition input) {
                return input != null && StringUtils.equals((String)transitionTitle, (String)input.name);
            }
        });
    }
}

