/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.functest.matcher.IssueLinksTypeMatcher;
import com.atlassian.jira.rest.client.api.JiraRestClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.RENAME_USER, Category.UPGRADE_TASKS})
public class TestUpgradeTask6085and6153
extends FuncTestCase {
    private JiraRestClient restClient;

    @Override
    protected void setUpTest() {
        this.restClient = this.createRestClient();
    }

    public void testLegacyDirectionPropertyTrueIfClonersSwapped() {
        this.administration.restoreDataWithBuildNumber("ClonersSwapped_Post5.2.6.xml", 855);
        Iterable issuelinksTypes = (Iterable)this.restClient.getMetadataClient().getIssueLinkTypes().claim();
        Assert.assertThat((Object)issuelinksTypes, (Matcher)Matchers.contains((Matcher)IssueLinksTypeMatcher.issueLinkType("Cloners", "is cloned by", "clones")));
    }

    public void testLegacyDirectionPropertyFalseIfClonersChanged() {
        this.administration.restoreDataWithBuildNumber("ClonersModified_Post5.2.6.xml", 855);
        Iterable issuelinksTypes = (Iterable)this.restClient.getMetadataClient().getIssueLinkTypes().claim();
        Assert.assertThat((Object)issuelinksTypes, (Matcher)Matchers.contains((Matcher)IssueLinksTypeMatcher.issueLinkType("Cloners", "copies", "is copied by")));
    }

    public void testLegacyDirectionPropertyFalseIfClonersUnmodified() {
        this.administration.restoreDataWithBuildNumber("ClonersUnmodified_Post5.2.6.xml", 855);
        Iterable issuelinksTypes = (Iterable)this.restClient.getMetadataClient().getIssueLinkTypes().claim();
        Assert.assertThat((Object)issuelinksTypes, (Matcher)Matchers.contains((Matcher)IssueLinksTypeMatcher.issueLinkType("Cloners", "is cloned by", "clones")));
    }
}

