/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.page.IssueSearchPage;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.navigator.jql.AbstractJqlFuncTest;
import java.util.Arrays;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

@WebTest(value={Category.FUNC_TEST, Category.RENAME_USER, Category.UPGRADE_TASKS})
public class TestUpgradeTask6039
extends AbstractJqlFuncTest {
    private static final String DASHBOARD_SYSTEM = "System Dashboard";
    private static final String DASHBOARD_MIXED_CASE_USER = "Mixed Case User Dashboard";
    private static final String FILTER_GIMME_EVERYTHING = "Gimme Everything";
    private static final String FILTER_SHOW_ALL_THE_THINGS = "Show All The Things";
    private static final String[] DEFAULT_SEARCH_COLUMNS = new String[]{"T", "Key", "Summary", "Assignee", "Reporter", "P", "Status", "Resolution", "Created", "Updated", "Due"};

    @Override
    protected void setUpTest() {
        String testDataFile = this.instanceIsMSSQL() ? "TestUpgradeTask6039-mssql.xml" : "TestUpgradeTask6039.xml";
        this.administration.restoreDataWithBuildNumber(testDataFile, 6003);
    }

    private boolean instanceIsMSSQL() {
        this.tester.gotoPage("/internal-error");
        return this.locator.xpath("//table/tbody/tr/th[text()='Database type']/following-sibling::td[text()='mssql']").exists();
    }

    public void testSearchForMixedCaseUsernames() {
        this.backdoor.issueNavControl().setPreferredSearchLayout("list-view", "admin");
        this.assertSearchWithResults("assignee = Mixed", "TEST-1");
        this.assertSearchWithResults("assignee = Admin", "TEST-8", "TEST-7", "TEST-6", "TEST-5", "TEST-4", "TEST-3", "TEST-2");
        this.assertSearchWithResults("reporter = Mixed", "TEST-3");
        this.assertSearchWithResults("\"Single User\" = Mixed", "TEST-5");
        this.assertSearchWithResults("\"Multi User\" = Mixed", "TEST-6");
        this.assertSearchWithResults("voter = Mixed", "TEST-7");
        this.assertSearchWithResults("watcher = Mixed", "TEST-8");
        this.assertSearchWithResults("\"Multi User\" = Mixed or watcher = Mixed", "TEST-8", "TEST-6");
        this.assertSearchWithResults("assignee was Mixed", "TEST-2", "TEST-1");
        this.assertSearchWithResults("reporter was Mixed", "TEST-4", "TEST-3");
        this.assertSearchWithResults("assignee was Mixed and reporter was Mixed", new String[0]);
        this.assertSearchWithResults("\"Single User\" = Mixed and (reporter was Mixed or assignee = Mixed)", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDashboardsAndFavouriteAssociations() {
        this.navigation.logout();
        try {
            this.navigation.login("Mixed");
            this.navigation.dashboard().navigateToFavourites();
            this.tester.assertTextPresent(DASHBOARD_SYSTEM);
            this.tester.assertTextNotPresent(DASHBOARD_MIXED_CASE_USER);
            this.navigation.dashboard().navigateToMy();
            this.tester.assertTextNotPresent(DASHBOARD_SYSTEM);
            this.tester.assertTextPresent(DASHBOARD_MIXED_CASE_USER);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin");
        }
        this.navigation.dashboard().navigateToFavourites();
        this.tester.assertTextNotPresent(DASHBOARD_SYSTEM);
        this.tester.assertTextPresent(DASHBOARD_MIXED_CASE_USER);
        this.navigation.dashboard().navigateToMy();
        this.tester.assertTextNotPresent(DASHBOARD_SYSTEM);
        this.tester.assertTextNotPresent(DASHBOARD_MIXED_CASE_USER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCommentAuthor() {
        this.navigation.issue().viewIssue("TEST-1");
        this.assertCommentAuthor("Administrator", "10000");
        this.tester.assertTextPresent("edit_comment_10000");
        this.tester.assertTextPresent("delete_comment_10000");
        this.navigation.issue().viewIssue("TEST-2");
        this.assertCommentAuthor("Mixed Case User", "10001");
        this.tester.assertTextNotPresent("edit_comment_10001");
        this.tester.assertTextPresent("delete_comment_10001");
        this.navigation.issue().viewIssue("TEST-3");
        this.assertCommentAuthor("Administrator", "10002");
        this.tester.assertTextPresent("edit_comment_10002");
        this.tester.assertTextPresent("delete_comment_10002");
        this.navigation.logout();
        try {
            this.navigation.login("Mixed");
            this.navigation.issue().viewIssue("TEST-1");
            this.assertCommentAuthor("Administrator", "10000");
            this.tester.assertTextNotPresent("edit_comment_10000");
            this.tester.assertTextNotPresent("delete_comment_10000");
            this.navigation.issue().viewIssue("TEST-2");
            this.assertCommentAuthor("Mixed Case User", "10001");
            this.tester.assertTextPresent("edit_comment_10001");
            this.tester.assertTextPresent("delete_comment_10001");
            this.navigation.issue().viewIssue("TEST-3");
            this.assertCommentAuthor("Administrator", "10002");
            this.tester.assertTextNotPresent("edit_comment_10002");
            this.tester.assertTextNotPresent("delete_comment_10002");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin");
        }
    }

    private void assertCommentAuthor(String expectedAuthor, String commentId) {
        TestUpgradeTask6039.assertEquals((String)("Author for commentId " + commentId), (String)expectedAuthor, (String)this.getCommentAuthor(commentId));
    }

    private String getCommentAuthor(String commentId) {
        Element commentAuthor = this.tester.getDialog().getElement("commentauthor_" + commentId + "_verbose");
        if (commentAuthor == null || !commentAuthor.getTagName().equalsIgnoreCase("a")) {
            throw new AssertionFailedError("Could not find an author for a comment with id " + commentId);
        }
        return StringUtils.trim((String)commentAuthor.getTextContent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchRequestsAndFavouriteAssociations() {
        this.navigation.logout();
        try {
            this.navigation.login("Mixed");
            this.navigation.manageFilters().favouriteFilters();
            this.tester.assertTextPresent(FILTER_GIMME_EVERYTHING);
            this.tester.assertTextNotPresent(FILTER_SHOW_ALL_THE_THINGS);
            this.navigation.manageFilters().myFilters();
            this.tester.assertTextNotPresent(FILTER_GIMME_EVERYTHING);
            this.tester.assertTextPresent(FILTER_SHOW_ALL_THE_THINGS);
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin");
        }
        this.navigation.manageFilters().favouriteFilters();
        this.tester.assertTextNotPresent(FILTER_GIMME_EVERYTHING);
        this.tester.assertTextNotPresent(FILTER_SHOW_ALL_THE_THINGS);
        this.navigation.manageFilters().myFilters();
        this.tester.assertTextPresent(FILTER_GIMME_EVERYTHING);
        this.tester.assertTextNotPresent(FILTER_SHOW_ALL_THE_THINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUseSavedColumnLayoutForMixedCaseUsername() {
        try {
            this.navigation.logout();
            this.navigation.login("Mixed");
            this.assertSearchColumns("Reporter", "T", "Key", "Summary", "Assignee");
        }
        finally {
            this.navigation.logout();
            this.navigation.login("admin");
        }
        this.assertSearchColumns(DEFAULT_SEARCH_COLUMNS);
    }

    private void assertSearchColumns(String ... expectedColumns) {
        IssueSearchPage issueSearchPage = this.navigation.issueNavigator().runPrintableSearch("");
        List<String> actualColumns = issueSearchPage.getResultsTable().getHeadingList();
        TestUpgradeTask6039.assertEquals(Arrays.asList(expectedColumns), actualColumns);
    }
}

