/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.backdoor.ColumnControl;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.meterware.httpunit.WebTable;
import java.util.List;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS, Category.SLOW_IMPORT})
public class TestUpgradeTask552
extends FuncTestCase {
    private static final String CUSTOM_FIELDS_ADMIN_TABLE_SELECTOR = "custom-fields";

    public void testUpgrade() {
        this.administration.restoreDataSlowOldWay("TestUpgradeTask552.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.tester.assertTextPresent("Custom Fields");
        WebTable customFieldsTable = new TableLocator(this.tester, CUSTOM_FIELDS_ADMIN_TABLE_SELECTOR).getTable();
        TestUpgradeTask552.assertEquals((int)3, (int)customFieldsTable.getRowCount());
        this.text.assertTextPresent(new TableLocator(this.tester, CUSTOM_FIELDS_ADMIN_TABLE_SELECTOR), "Epic");
        this.text.assertTextPresent(new TableLocator(this.tester, CUSTOM_FIELDS_ADMIN_TABLE_SELECTOR), "Tags");
        Function<ColumnControl.ColumnItem, String> extractLabelsFromColumns = new Function<ColumnControl.ColumnItem, String>(){

            public String apply(ColumnControl.ColumnItem column) {
                return column.label;
            }
        };
        List systemColumns = Lists.transform(this.backdoor.columnControl().getSystemDefaultColumns(), (Function)extractLabelsFromColumns);
        TestUpgradeTask552.assertTrue((String)"Column Labels is present", (boolean)systemColumns.contains("Labels"));
        TestUpgradeTask552.assertTrue((String)"Column Epic is present", (boolean)systemColumns.contains("Epic"));
        TestUpgradeTask552.assertTrue((String)"Column Tags is present", (boolean)systemColumns.contains("Tags"));
    }

    public void testUpgradeNoSystemField() {
        this.administration.restoreDataSlowOldWay("TestUpgradeTask552NoSystemField.xml");
        this.navigation.gotoAdminSection(Navigation.AdminSection.VIEW_CUSTOM_FIELDS);
        this.text.assertTextPresent("Epic/Theme");
        this.navigation.issue().viewIssue("HSP-1");
        this.text.assertTextPresent("Epic/Theme");
        this.text.assertTextSequence(new IdLocator(this.tester, "customfield_10000-val"), "This", "a", "is", "test");
    }

    public void testUpgradeSystemField() {
        this.administration.restoreDataSlowOldWay("TestUpgradeTask552SystemField.xml");
        this.navigation.issue().viewIssue("UPG-2");
        this.text.assertTextPresent("Label");
        this.text.assertTextPresent("TestLabel");
        this.text.assertTextPresent(new IdLocator(this.tester, "labels-10001-value"), "two");
    }
}

