/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade.tasks;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;

@WebTest(value={Category.FUNC_TEST, Category.UPGRADE_TASKS})
public class TestPluginStateMigration
extends FuncTestCase {
    private static final String PLUGIN_KEY = "com.atlassian.jira.jira-monitoring-plugin";

    public void testUpgrade() {
        this.administration.restoreDataSlowOldWay("TestPluginStateUpgrade.xml");
        this.checkPluginStateRespected();
    }

    public void testPluginStateImportedCorrectly() {
        this.administration.plugins().enablePlugin(PLUGIN_KEY);
        this.administration.restoreData("TestPluginImport.xml");
        this.checkPluginStateRespected();
    }

    public void testPluginStateImportsDotPrefixCorrectly() {
        this.administration.plugins().enablePlugin(PLUGIN_KEY);
        this.administration.restoreDataSlowOldWay("TestPluginDotPrefixImport.xml");
        this.checkPluginStateRespected();
    }

    @Override
    protected void tearDownTest() {
        this.administration.plugins().enablePlugin(PLUGIN_KEY);
    }

    private void checkPluginStateRespected() {
        TestPluginStateMigration.assertTrue((String)"Plugin should be disabled.", (boolean)this.administration.plugins().isPluginDisabled(PLUGIN_KEY));
    }
}

