/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.upgrade;

import com.atlassian.jira.rest.v2.upgrade.UpgradeResultBean;
import com.atlassian.jira.testkit.client.JIRAEnvironmentData;
import com.atlassian.jira.testkit.client.RestApiClient;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;

public class UpgradeManagerClient
extends RestApiClient {
    private final JIRAEnvironmentData environmentData;

    public UpgradeManagerClient(JIRAEnvironmentData environmentData) {
        super(environmentData);
        this.environmentData = environmentData;
    }

    public void addUpgradeTask(String task) {
        this.getUpgradeBackDoor().path("addUpgrade").queryParam("task", task).post();
    }

    public void doUpgrade() {
        this.getUpgradeBackDoor().path("doUpgrade").post();
    }

    public void doDelayedUpgradesAndWaitForCompletion() {
        this.getUpgradeResource().post();
        boolean upgradeComplete = false;
        do {
            try {
                UpgradeResultBean result = (UpgradeResultBean)this.getUpgradeResource().get(UpgradeResultBean.class);
                upgradeComplete = true;
            }
            catch (UniformInterfaceException e) {
                upgradeComplete = e.getResponse().getStatus() != 303;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        } while (!upgradeComplete);
    }

    private WebResource getUpgradeResource() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("api").path("2").path("upgrade");
    }

    private WebResource getUpgradeBackDoor() {
        return this.resourceRoot(this.environmentData.getBaseUrl().toExternalForm()).path("rest").path("func-test").path("1.0").path("upgradeManager");
    }
}

