/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.AbstractTpmLdapTest;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;
import org.junit.Ignore;

@Ignore(value="LDAP Performance test.  Only ever run singularly in a special TPM environment")
@WebTest(value={Category.TPM, Category.LDAP, Category.PERFORMANCE})
public class TestTpmLdapSyncPerformance10k
extends AbstractTpmLdapTest {
    public void testADSyncPerformance() throws Exception {
        int indexSecondsTakenEnd;
        int i;
        int indexSecondsTakenStart;
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.tester.assertTextPresent("User Directories");
        this.log("Attempting to add an Active Directory LDAP User Directory...");
        this.addActiveDirectory();
        WebTable table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "JIRA Internal Directory");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 1, "LDAP Directory");
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        WebLink link = tblDirectoryList.getTableCell(2, 3).getLinkWith("up");
        this.navigation.clickLink(link);
        table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "LDAP Directory");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 1, "JIRA Internal Directory");
        int count = 0;
        while (!this.tester.getDialog().isTextInResponse("Last synchronised")) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            if (++count >= 60) {
                TestTpmLdapSyncPerformance10k.fail((String)"Active directory sync has taken too long!");
            }
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        }
        String response = this.tester.getDialog().getResponseText();
        int seconds = Integer.parseInt(response.substring(indexSecondsTakenStart = response.indexOf("(took ", i = response.indexOf("Last synchronised")) + 6, indexSecondsTakenEnd = response.indexOf("s).", indexSecondsTakenStart)));
        if (seconds > 300) {
            TestTpmLdapSyncPerformance10k.fail((String)("Active directory sync has taken too long! ( " + seconds + ")"));
        }
    }

    private void addActiveDirectory() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", "LDAP Directory");
        this.tester.selectOption("type", "Microsoft Active Directory");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn10K());
        this.tester.setFormElement("ldapUserObjectclass", "user");
        this.tester.setFormElement("ldapUserFilter", "(&(objectCategory=Person)(sAMAccountName=*))");
        this.tester.setFormElement("ldapUserUsername", "sAMAccountName");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "unicodePwd");
        this.tester.setFormElement("ldapGroupObjectclass", "group");
        this.tester.setFormElement("ldapGroupFilter", "(objectCategory=Group)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "member");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.checkCheckbox("ldapPagedresults", "true");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.text.assertTextPresent("The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent("JIRA Internal Directory");
        this.tester.assertTextPresent("LDAP Directory");
    }

    private String getBaseDn10K() {
        if (this.getLdapServer().equals("crowd-ad1")) {
            return "ou=loadTesting10k,dc=sydney,dc=atlassian,dc=com";
        }
        return "ou=loadTesting10k,dc=tpm,dc=atlassian,dc=com";
    }
}

