/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.rest.api.issue.IssueCreateResponse;
import com.atlassian.jira.testkit.client.restclient.Issue;
import com.atlassian.jira.webtests.ztests.tpm.ldap.AbstractTpmLdapTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.LdapOperationsHelper;
import javax.naming.NamingException;
import org.apache.commons.lang.RandomStringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
public class TestTpmLdapRename
extends AbstractTpmLdapTest {
    public void testScenario1() throws Exception {
        String projectKey = this.generateProjectKey();
        this.setUpScenarioData(projectKey);
        String issueKey = this.createIssueForUser(projectKey, "ron");
        LdapOperationsHelper ldapOperationsHelper = this.getLdapOperationsHelper();
        ldapOperationsHelper.removeUser("john");
        ldapOperationsHelper.renameUser("ron", "john");
        this.navigation.logout();
        this.navigation.login("john", "password");
        Issue issue = this.backdoor.issues().getIssue(projectKey + "-1");
        Assert.assertThat((Object)issue.fields.assignee.name, (Matcher)CoreMatchers.equalTo((Object)"john"));
        this.clearScenarioData(projectKey, issueKey);
    }

    public void testCheckIfRenameIsTrackedInDefaultConfiguration() throws Exception {
        this.addUser("wilma");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.tester.clickLinkWithText("Test");
        this.tester.setFormElement("username", "wilma");
        this.tester.setFormElement("password", "password");
        this.tester.submit("test");
        this.assertions.getTextAssertions().assertTextNotPresent("Test user rename is configured and tracked : Succeeded");
    }

    private String createIssueForUser(String projectKey, String username) {
        IssueCreateResponse issueResponse = this.backdoor.issues().createIssue(projectKey, "Testing LDAP rename", "ron");
        return issueResponse.key;
    }

    private LdapOperationsHelper getLdapOperationsHelper() {
        return new LdapOperationsHelper(this.getLdapServer(), this.getUserDn(), this.getPassword(), this.getBaseDn(), this.isActiveDirectory());
    }

    private void setUpScenarioData(String projectKey) throws NamingException, InterruptedException {
        this.backdoor.project().addProject(projectKey + "  test project", projectKey, "admin");
        this.addUser("ron");
        this.addUser("john");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.tester.clickLinkWithText("Synchronise");
        this.backdoor.usersAndGroups().addUserToGroup("ron", "jira-users");
        this.backdoor.usersAndGroups().addUserToGroup("ron", "jira-developers");
        this.backdoor.usersAndGroups().addUserToGroup("john", "jira-users");
        this.backdoor.usersAndGroups().addUserToGroup("john", "jira-developers");
    }

    private void clearScenarioData(String projectKey, String issueKey) throws NamingException {
        this.backdoor.issues().deleteIssue(issueKey, true);
        this.backdoor.project().deleteProject(projectKey);
        this.deleteUserIfExists("ron");
        this.deleteUserIfExists("john");
    }

    private void gotoViewUser(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
    }

    private void addUser(String username) {
        this.deleteUserIfExists(username);
        this.assertions.getUserAssertions().assertUserDoesNotExist(username);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("create_user");
        this.tester.setFormElement("username", username);
        this.tester.setFormElement("fullname", this.generateUserFullName(username));
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("email", username + "@nicedomain.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists(username);
        this.assertions.getUserAssertions().assertUserDetails(username, this.generateUserFullName(username), username + "@nicedomain.com", "LDAP Directory");
    }

    private void deleteUserIfExists(String username) {
        if (this.assertions.getUserAssertions().userExists(username)) {
            this.log("User " + username + "  was found - attempting to clean up before running test.");
            this.gotoViewUser(username);
            this.tester.clickLink("deleteuser_link");
            this.tester.submit("Delete");
        }
    }

    private String generateUserFullName(String username) {
        return username.subSequence(0, 1).toString().toUpperCase() + username.substring(1, username.length()) + " Nicelastname";
    }

    private String generateProjectKey() {
        return RandomStringUtils.randomAlphabetic((int)5).toUpperCase();
    }
}

