/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.AbstractTpmLdapTest;
import com.meterware.httpunit.WebLink;
import com.meterware.httpunit.WebTable;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
public class TestTpmLdapAdvanced
extends AbstractTpmLdapTest {
    public void testDisabledDirectory() throws Exception {
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.log("User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("create_user");
        this.tester.setFormElement("username", "wilma");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.tester.clickLinkWithText("Disable", 1);
        this.assertions.getTextAssertions().assertTextPresent("LDAP Directory</span>  <em>(inactive)</em>");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.tester.clickLinkWithText("Enable");
        this.assertions.getTextAssertions().assertTextNotPresent("LDAP Directory (inactive)");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.deleteUser("wilma");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
    }

    public void testSynchroniseDirectory() throws Exception {
        if (this.assertions.getUserAssertions().userExists("wilma")) {
            this.log("User wilma was found - attempting to clean up before running test.");
            this.deleteUser("wilma");
        }
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.synchroniseDirectory(1);
        this.assertions.getTextAssertions().assertTextNotPresent("Never synchronised");
        if (this.isActiveDirectory()) {
            this.log("Attempting to add an Active Directory LDAP User Directory...");
            this.addActiveDirectory("LDAP Directory 2");
        } else {
            this.log("Attempting to add an Open LDAP User Directory...");
            this.addOpenLdap("LDAP Directory 2");
        }
        WebTable table = this.assertions.getTableAssertions().getWebTable("directory-list");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 1, 1, "LDAP Directory");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 2, 1, "JIRA Internal Directory");
        this.assertions.getTableAssertions().assertTableCellHasText(table, 3, 1, "LDAP Directory 2");
        this.assertions.getTextAssertions().assertTextPresent("Never synchronised");
        this.synchroniseDirectory(3);
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_BROWSER);
        this.tester.clickLink("create_user");
        this.tester.setFormElement("username", "wilma");
        this.tester.selectOption("directoryId", "LDAP Directory");
        this.tester.setFormElement("fullname", "Wilma Flintstone");
        this.tester.setFormElement("password", "password");
        this.tester.setFormElement("confirm", "password");
        this.tester.setFormElement("email", "wilma@bedrock.com");
        this.tester.submit("Create");
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.tester.clickLinkWithText("Disable", 1);
        this.assertions.getTextAssertions().assertTextPresent("LDAP Directory</span>  <em>(inactive)</em>");
        this.synchroniseDirectory(3);
        this.assertions.getUserAssertions().assertUserExists("wilma");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory 2");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        this.tester.clickLinkWithText("Enable");
        this.assertions.getTextAssertions().assertTextNotPresent("LDAP Directory  <em>(inactive)</em>");
        this.assertions.getUserAssertions().assertUserDetails("wilma", "Wilma Flintstone", "wilma@bedrock.com", "LDAP Directory");
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        WebLink link = tblDirectoryList.getTableCell(3, 4).getLinkWith("Disable");
        this.navigation.clickLink(link);
        tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        link = tblDirectoryList.getTableCell(3, 4).getLinkWith("Remove");
        this.navigation.clickLink(link);
        this.deleteUser("wilma");
        this.assertions.getUserAssertions().assertUserDoesNotExist("wilma");
    }

    private void addActiveDirectory(String name) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", name);
        this.tester.selectOption("type", "Microsoft Active Directory");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "636");
        this.tester.checkCheckbox("useSSL", "true");
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapUserObjectclass", "user");
        this.tester.setFormElement("ldapUserFilter", "(&(objectCategory=Person)(sAMAccountName=*))");
        this.tester.setFormElement("ldapUserUsername", "sAMAccountName");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "unicodePwd");
        this.tester.setFormElement("ldapGroupObjectclass", "group");
        this.tester.setFormElement("ldapGroupFilter", "(objectCategory=Group)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "member");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.assertExtendedTestPageAndReturnToDirectoryList();
    }

    private void addOpenLdap(String name) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/ldap/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-ldap-form");
        this.tester.setFormElement("name", name);
        this.tester.selectOption("type", "OpenLDAP");
        this.tester.setFormElement("hostname", this.getLdapServer());
        this.tester.setFormElement("port", "389");
        this.tester.setFormElement("ldapUserdn", this.getUserDn());
        this.tester.setFormElement("ldapBasedn", this.getBaseDn());
        this.tester.setFormElement("ldapPassword", this.getPassword());
        this.tester.setFormElement("ldapUserObjectclass", "inetorgperson");
        this.tester.setFormElement("ldapUserFilter", "(objectclass=inetorgperson)");
        this.tester.setFormElement("ldapUserUsername", "cn");
        this.tester.setFormElement("ldapUserUsernameRdn", "cn");
        this.tester.setFormElement("ldapUserFirstname", "givenName");
        this.tester.setFormElement("ldapUserLastname", "sn");
        this.tester.setFormElement("ldapUserDisplayname", "displayName");
        this.tester.setFormElement("ldapUserEmail", "mail");
        this.tester.setFormElement("ldapUserGroup", "memberOf");
        this.tester.setFormElement("ldapUserPassword", "userPassword");
        this.tester.setFormElement("ldapGroupObjectclass", "groupOfUniqueNames");
        this.tester.setFormElement("ldapGroupFilter", "(objectclass=groupOfUniqueNames)");
        this.tester.setFormElement("ldapGroupName", "cn");
        this.tester.setFormElement("ldapGroupDescription", "description");
        this.tester.setFormElement("ldapGroupUsernames", "uniqueMember");
        this.tester.setFormElement("ldapPermissionOption", "READ_WRITE");
        this.tester.submit("test");
        this.text.assertTextPresent("Connection test successful");
        this.tester.submit("save");
        this.assertExtendedTestPageAndReturnToDirectoryList();
    }

    private void deleteUser(String username) {
        this.gotoViewUser(username);
        this.tester.clickLink("deleteuser_link");
        this.tester.submit("Delete");
    }

    private void gotoViewUser(String username) {
        this.tester.gotoPage("/secure/admin/user/ViewUser.jspa?name=" + username);
    }
}

