/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.locator.IdLocator;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.WebLink;
import java.io.IOException;
import org.xml.sax.SAXException;

@WebTest(value={Category.FUNC_TEST, Category.LDAP, Category.TPM})
public class TestBrowseUserDirectories
extends FuncTestCase {
    private static final String JAACS_APPLICATION_NAME = "CousinMabel";
    private static final String JAACS_APPLICATION_CREDENTIAL = "secret";

    @Override
    protected void setUpTest() {
        this.administration.restoreBlankInstance();
        this.navigation.gotoAdmin();
        this.setUpJaacsServer();
    }

    public void testEmptyData() {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/directories/list");
        this.tester.setWorkingForm("");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "The table below shows the user directories currently configured for JIRA.");
        this.tester.assertTextPresent("<button id=\"new-directory\" class=\"aui-button\">Add Directory</button>");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(false).hasOnlyEditOperation();
    }

    public void testMultipleDirectories() throws IOException, SAXException {
        this.log("Add a bunch of directories");
        this.addDirectories();
        this.log("Checking directories present in the correct order");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "The table below shows the user directories currently configured for JIRA.");
        UserDirectoryTable userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(false).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(2).contains("10000", "CROWD1", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(3).contains("10001", "CROWD2", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(4).contains("10002", "CROWD3", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        this.log("Moving directory up");
        this.log("Checking directories present in the correct order");
        WebLink link = userDirectoryTable.getTableCell(2, 3).getLinkWith("up");
        this.navigation.clickLink(link);
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("10000", "CROWD1", "Atlassian Crowd").hasMoveUp(false).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(2).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(true).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(3).contains("10001", "CROWD2", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(4).contains("10002", "CROWD3", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        this.log("Moving directory down");
        this.log("Checking directories present in the correct order");
        link = userDirectoryTable.getTableCell(2, 3).getLinkWith("down");
        this.navigation.clickLink(link);
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("10000", "CROWD1", "Atlassian Crowd").hasMoveUp(false).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(2).contains("10001", "CROWD2", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(3).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(true).hasMoveDown(true).hasOnlyEditOperation();
        userDirectoryTable.assertRow(4).contains("10002", "CROWD3", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(false).hasDisableEditSynchroniseOperations();
        this.log("Moving directory up");
        this.log("Checking directories present in the correct order");
        link = userDirectoryTable.getTableCell(4, 3).getLinkWith("up");
        this.navigation.clickLink(link);
        userDirectoryTable = new UserDirectoryTable(this);
        userDirectoryTable.assertRow(1).contains("10000", "CROWD1", "Atlassian Crowd").hasMoveUp(false).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(2).contains("10001", "CROWD2", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(3).contains("10002", "CROWD3", "Atlassian Crowd").hasMoveUp(true).hasMoveDown(true).hasDisableEditSynchroniseOperations();
        userDirectoryTable.assertRow(4).contains("1", "JIRA Internal Directory", "Internal").hasMoveUp(true).hasMoveDown(false).hasOnlyEditOperation();
        userDirectoryTable = new UserDirectoryTable(this);
        link = userDirectoryTable.getTableCell(4, 3).getLinkWith("up");
        this.navigation.clickLink(link);
        userDirectoryTable = new UserDirectoryTable(this);
        link = userDirectoryTable.getTableCell(3, 3).getLinkWith("up");
        this.navigation.clickLink(link);
        userDirectoryTable = new UserDirectoryTable(this);
        link = userDirectoryTable.getTableCell(2, 3).getLinkWith("up");
        this.navigation.clickLink(link);
    }

    private void addDirectories() {
        this.addCrowdDirectory("CROWD1", JAACS_APPLICATION_NAME, this.tester.getTestContext().getBaseUrl(), JAACS_APPLICATION_CREDENTIAL);
        this.addCrowdDirectory("CROWD2", JAACS_APPLICATION_NAME, this.tester.getTestContext().getBaseUrl(), JAACS_APPLICATION_CREDENTIAL);
        this.addCrowdDirectory("CROWD3", JAACS_APPLICATION_NAME, this.tester.getTestContext().getBaseUrl(), JAACS_APPLICATION_CREDENTIAL);
    }

    private void addCrowdDirectory(String name, String applicationName, String serverUrl, String password) {
        this.navigation.gotoPage("/plugins/servlet/embedded-crowd/configure/crowd/");
        this.text.assertTextPresent(new IdLocator(this.tester, "embcwd"), "Server Settings");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("name", "");
        this.tester.submit("test");
        this.text.assertTextPresent("Name is a required field.");
        this.text.assertTextPresent("Server URL is a required field.");
        this.text.assertTextPresent("Application name is a required field.");
        this.text.assertTextPresent("Application password is a required field.");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("name", name);
        this.tester.setFormElement("crowdServerUrl", serverUrl);
        this.tester.setFormElement("applicationName", applicationName);
        this.tester.setFormElement("applicationPassword", password);
        this.tester.submit("test");
        this.tester.setWorkingForm("configure-crowd-form");
        this.tester.setFormElement("crowdServerUrl", "http://dummmy.domain.priv/crowd");
        this.tester.submit("save");
    }

    private void setUpJaacsServer() {
        this.navigation.gotoPage("secure/project/ConfigureCrowdServer.jspa");
        this.tester.clickLink("crowd-add-application");
        this.tester.setWorkingForm("edit-crowd-application");
        this.tester.setFormElement("name", JAACS_APPLICATION_NAME);
        this.tester.setFormElement("credential", JAACS_APPLICATION_CREDENTIAL);
        this.tester.clickButton("edit-crowd-application-submit");
    }
}

