/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.tpm.ldap;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.Navigation;
import com.atlassian.jira.functest.framework.locator.TableLocator;
import com.atlassian.jira.webtests.ztests.tpm.ldap.UserDirectoryTable;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebTable;

public abstract class AbstractTpmLdapTest
extends FuncTestCase {
    protected boolean isActiveDirectory() {
        String ldapType = this.getConfigurationOption("ldap.type");
        if (ldapType == null) {
            throw new IllegalStateException("Missing configuration for 'ldap.type'.");
        }
        if (ldapType.equals("ActiveDirectory")) {
            return true;
        }
        if (ldapType.equals("OpenLdap")) {
            return false;
        }
        throw new IllegalStateException("Unknown LDAP type '" + ldapType + "'");
    }

    protected String getTypeDisplayName() {
        String ldapType = this.getConfigurationOption("ldap.type");
        if (ldapType == null) {
            throw new IllegalStateException("Missing configuration for 'ldap.type'.");
        }
        if (ldapType.equals("ActiveDirectory")) {
            return "Microsoft Active Directory";
        }
        if (ldapType.equals("OpenLdap")) {
            return "OpenLDAP";
        }
        throw new IllegalStateException("Unknown LDAP type '" + ldapType + "'");
    }

    protected String getUserDn() {
        String userDn = this.getConfigurationOption("ldap.userdn");
        if (userDn == null) {
            if (this.isActiveDirectory()) {
                if (this.getLdapServer().equals("crowd-ad1.sydney.atlassian.com")) {
                    return "cn=Administrator,cn=Users,dc=sydney,dc=atlassian,dc=com";
                }
                return "cn=Administrator,cn=Users,dc=tpm,dc=atlassian,dc=com";
            }
            if (this.getLdapServer().equals("crowd-op23") || this.getLdapServer().equals("172.22.200.133")) {
                return "o=sgi,c=us";
            }
            return "cn=admin,dc=example,dc=com";
        }
        return userDn;
    }

    protected String getPassword() {
        String password = this.getConfigurationOption("ldap.password");
        if (password == null) {
            if (this.isActiveDirectory()) {
                if (this.getLdapServer().equals("crowd-ad1.sydney.atlassian.com")) {
                    return "atlassian";
                }
                return "5P3rtaaah";
            }
            return "secret";
        }
        return password;
    }

    protected String getBaseDn() {
        String baseDn = this.getConfigurationOption("ldap.basedn");
        if (baseDn == null) {
            if (this.isActiveDirectory()) {
                if (this.getLdapServer().equals("crowd-ad1.sydney.atlassian.com")) {
                    return "OU=People,dc=sydney,dc=atlassian,dc=com";
                }
                return "dc=tpm,dc=atlassian,dc=com";
            }
            if (this.getLdapServer().equals("crowd-op23") || this.getLdapServer().equals("172.22.200.133")) {
                return "ou=JIRA-TPM,o=sgi,c=us";
            }
            return "dc=example,dc=com";
        }
        return baseDn;
    }

    protected String getConfigurationOption(String key) {
        String value = System.getProperty(key);
        if (value != null) {
            return value;
        }
        return this.environmentData.getProperty(key);
    }

    protected String getLdapServer() {
        String server = this.getConfigurationOption("ldap.server");
        if (server == null) {
            if (this.isActiveDirectory()) {
                return "atlas-win32ie9.tpm.atlassian.com";
            }
            return "localhost";
        }
        return server;
    }

    protected void assertExtendedTestPageAndReturnToDirectoryList() {
        this.tester.assertTextPresent("Test Remote Directory Connection");
        this.tester.assertTextPresent("For extended testing enter the credentials of a user in the remote directory");
        this.tester.clickLinkWithText("Back to directory list");
    }

    protected void synchroniseDirectory(int row) throws InterruptedException {
        this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
        WebTable tblDirectoryList = new TableLocator(this.tester, "directory-list").getTable();
        this.log("Attempting to synchronise Directory " + row);
        TableCell operations = tblDirectoryList.getTableCell(row, 4);
        if (operations.asText().contains("Synchronising")) {
            this.log("Directory " + row + " is already synchronising ... we will wait until it is complete.");
        } else {
            this.navigation.clickLink(operations.getLinkWith("Synchronise"));
        }
        int attempts = 0;
        while (true) {
            Thread.sleep(100L);
            this.navigation.gotoAdminSection(Navigation.AdminSection.USER_DIRECTORIES);
            operations = new UserDirectoryTable(this).getTableCell(row, 4);
            if (!operations.asText().contains("Synchronising")) break;
            if (++attempts > 100) {
                AbstractTpmLdapTest.fail((String)("Directory did not finish synchronising. Giving up after " + attempts + " retries."));
            }
            this.log("Still synchronising ...");
        }
        AbstractTpmLdapTest.assertNotNull((Object)operations.getLinkWith("Synchronise"));
        this.log("Synchronise is finished.");
    }
}

