/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.webtests.ztests.timezone;

import com.atlassian.jira.functest.framework.FuncTestCase;
import com.atlassian.jira.functest.framework.suite.Category;
import com.atlassian.jira.functest.framework.suite.WebTest;
import com.meterware.httpunit.WebTable;
import java.util.TimeZone;

@WebTest(value={Category.FUNC_TEST, Category.TIME_ZONES})
public class TestIssueChangeHistory
extends FuncTestCase {
    private static final String AUSTRALIA_SYDNEY = "Australia/Sydney";
    private String standardTimezoneName;
    private String daylightSavingTimezoneName;

    @Override
    protected void setUpTest() {
        super.setUpTest();
        this.administration.restoreData("TestIssueChangeHistory.xml");
        this.administration.generalConfiguration().setDefaultUserTimeZone(AUSTRALIA_SYDNEY);
        this.standardTimezoneName = TimeZone.getTimeZone(AUSTRALIA_SYDNEY).getDisplayName(false, 0);
        this.daylightSavingTimezoneName = TimeZone.getTimeZone(AUSTRALIA_SYDNEY).getDisplayName(true, 0);
    }

    public void testChangeDueDate() throws Exception {
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("MKY-2");
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("duedate", "12/May/09");
        this.tester.submit("Update");
        this.tester.clickLinkWithText("History");
        WebTable changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"Due Date", "", "12/May/09 " + this.standardTimezoneName});
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("duedate", "11/May/11");
        this.tester.submit("Update");
        WebTable changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"Due Date", "12/May/09 " + this.standardTimezoneName, "11/May/11 " + this.standardTimezoneName});
        this.navigation.login("berlin");
        this.navigation.issue().viewIssue("MKY-2");
        changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"F\u00e4lligkeitsdatum", "", "12/Mai/09 " + this.standardTimezoneName});
        changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"F\u00e4lligkeitsdatum", "12/Mai/09 " + this.standardTimezoneName, "11/Mai/11 " + this.standardTimezoneName});
    }

    public void testDateCF() throws Exception {
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("MKY-2");
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("customfield_10000", "03/May/11");
        this.tester.submit("Update");
        this.tester.clickLinkWithText("History");
        WebTable changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"DatePickerCF", "", "3/May/11 " + this.standardTimezoneName});
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("customfield_10000", "01/Jan/09");
        this.tester.submit("Update");
        WebTable changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"DatePickerCF", "3/May/11 " + this.standardTimezoneName, "1/Jan/09 " + this.daylightSavingTimezoneName});
        this.navigation.login("berlin");
        this.navigation.issue().viewIssue("MKY-2");
        changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"DatePickerCF", "", "3/Mai/11 " + this.standardTimezoneName});
        changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"DatePickerCF", "3/Mai/11 " + this.standardTimezoneName, "1/Jan/09 " + this.daylightSavingTimezoneName});
    }

    public void testDateTimeCF() throws Exception {
        this.navigation.login("admin");
        this.navigation.issue().viewIssue("MKY-2");
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("customfield_10001", "3/May/11 08:40 AM");
        this.tester.submit("Update");
        this.tester.clickLinkWithText("History");
        WebTable changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"DateTimeCF", "", "03/May/11 8:40 AM"});
        this.tester.clickLink("edit-issue");
        this.tester.setWorkingForm("issue-edit");
        this.tester.setFormElement("customfield_10001", "3/May/10 03:40 AM");
        this.tester.submit("Update");
        WebTable changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"DateTimeCF", "03/May/11 8:40 AM", "03/May/10 3:40 AM"});
        this.navigation.login("berlin");
        this.navigation.issue().viewIssue("MKY-2");
        changehistory_10300 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10300");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10300.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10300, new String[]{"DateTimeCF", "", "03/Mai/11 12:40 AM"});
        changehistory_10301 = this.tester.getDialog().getWebTableBySummaryOrId("changehistory_10301");
        TestIssueChangeHistory.assertEquals((String)("Expected table to have 2 rows, but found " + changehistory_10301.getRowCount()), (int)2, (int)changehistory_10300.getRowCount());
        this.assertions.getTableAssertions().assertTableContainsRowOnce(changehistory_10301, new String[]{"DateTimeCF", "03/Mai/11 12:40 AM ", "02/Mai/10 7:40 PM "});
    }
}

